package com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Description:记录每次结算匹配的kms数据单号，匹配完后，定时更新状态。
 * @Author qiancheng
 * @Date 2023/11/26
 */
@Data
@TableName("tpm_audit_fee_settlement_check_update_matched")
@Entity(name = "tpm_audit_fee_settlement_check_update_matched")
@ApiModel(value = "AuditFeeSettlementCheckUpdateMatched", description = "TPM-结算匹配的kms数据单号")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_settlement_check_update_matched", comment = "TPM-结算匹配的kms数据单号")
@Table(name = "tpm_audit_fee_settlement_check_update_matched", indexes = {@Index(name = "settlement_check_update_matched_index1", columnList = "del_flag,tenant_code,create_time")})
public class AuditFeeSettlementCheckUpdateMatched extends TenantFlagOpEntity {

    /**
     * 数据编码
     */
    @ApiModelProperty(name = "数据编码", notes = "数据编码")
    @Column(name = "tpm_deduction_code",  length = 125, columnDefinition = "VARCHAR(125) COMMENT '数据编码'")
    private String tpmDeductionCode;

    /**
     * 数量来源
     */
    @ApiModelProperty(name = "数量来源", notes = "数量来源")
    @Column(name = "data_source",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '数量来源'")
    private String dataSource;

}
