package com.biz.crm.tpm.business.audit.fee.local.entity.track;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author liyang
 * @date 2023/09/28
 */
@ApiModel(value = "AuditFeeDiffTrack", description = "核销差异费用追踪")
@TableName("tpm_audit_fee_diff_track")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_track")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_track", comment = "核销差异费用追踪")
@Table(name = "tpm_audit_fee_diff_track")
public class AuditFeeDiffTrack extends TenantFlagOpEntity {

  @ApiModelProperty("业态 数据字典：mdm_business_format")
  @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
  private String businessFormatCode;

  @ApiModelProperty("业务单元[数据字典:mdm_business_unit]")
  @Column(name = "business_unit_code", length = 32, columnDefinition = "varchar(32) COMMENT '业务单元'")
  private String businessUnitCode;

  @ApiModelProperty(name = "区域编码[字典MDM_CUSTOMIZE_ORG]", notes = "")
  @Column(name = "region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码'")
  private String regionCode;

  @ApiModelProperty("部门编码")
  @Column(name = "department_code", length = 32, columnDefinition = "varchar(255) COMMENT '部门编码'")
  private String departmentCode;

  @ApiModelProperty("部门名称")
  @Column(name = "department_name", length = 64, columnDefinition = "varchar(1024) COMMENT '部门名称'")
  private String departmentName;

  @ApiModelProperty("差异费用处理编码")
  @Column(name = "plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '差异费用处理编码'")
  private String planCode;

  @ApiModelProperty("差异费用处理名称")
  @Column(name = "plan_name", length = 64, columnDefinition = "varchar(255) COMMENT '差异费用处理名称'")
  private String planName;

  @ApiModelProperty("方案开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "begin_date", columnDefinition = "datetime COMMENT '方案开始时间'")
  private Date beginDate;

  @ApiModelProperty("方案结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "end_date",  columnDefinition = "datetime COMMENT '方案结束时间'")
  private Date endDate;

  @ApiModelProperty("方案主题")
  @Column(name = "plan_title", length = 1000, columnDefinition = "varchar(1000) COMMENT '方案主题'")
  private String planTitle;

  @ApiModelProperty("方案目的")
  @Column(name = "plan_goal", length = 1000, columnDefinition = "varchar(1000) COMMENT '方案目的'")
  private String planGoal;

  @ApiModelProperty("活动背景")
  @Column(name = "activity_background", length = 1000, columnDefinition = "varchar(1000) COMMENT '活动背景'")
  private String activityBackground;

  @ApiModelProperty("活动目标")
  @Column(name = "activity_target", length = 1000, columnDefinition = "varchar(1000) COMMENT '活动目标'")
  private String activityTarget;

  @ApiModelProperty("明细说明")
  @Column(name = "detail_explain", length = 1000, columnDefinition = "varchar(1000) COMMENT '明细说明'")
  private String detailExplain;

  @ApiModelProperty("申请金额汇总")
  @Column(name = "sales_amount", columnDefinition = "decimal(24,6) COMMENT '申请金额汇总'")
  private BigDecimal salesAmount;

  @ApiModelProperty("审批状态")
  @Column(name = "process_status", length = 10, columnDefinition = "varchar(10) COMMENT '审批状态'")
  private String processStatus;

  @ApiModelProperty("流程编号")
  @Column(name = "process_no", length = 64, columnDefinition = "varchar(64) COMMENT '流程编号'")
  private String processNo;

  @ApiModelProperty("单据来源")
  @Column(name = "datasource", length = 24, columnDefinition = "varchar(24) COMMENT '单据来源'")
  private String datasource;

  @ApiModelProperty("是否结案")
  @Column(name = "whole_audit", length = 10, columnDefinition = "varchar(10) COMMENT '是否结案'")
  private String wholeAudit;

  /**
   * 是否关闭，   Y是N否
   */
  @ApiModelProperty(name = "isClose", notes = "是否关闭", value = "是否关闭，   Y是N否")
  @Column(name = "is_close", nullable = false, length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否关闭 '")
  private String isClose;

  @ApiModelProperty("暂存（true:暂存,false:保存）")
  @Column(name = "temp_save", length = 1, columnDefinition = "char(1) COMMENT '暂存（true:暂存,false:保存'")
  private Boolean tempSave;
}
