package com.biz.crm.tpm.business.audit.fee.local.entity.track;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author liyang
 * @date 2023/09/28
 */
@ApiModel(value = "AuditFeeDiffTrackDetail", description = "核销差异费用追踪细案")
@TableName("tpm_audit_fee_diff_track_detail")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_track_detail")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_track_detail", comment = "核销差异费用追踪细案")
@Table(name = "tpm_audit_fee_diff_track_detail",
        indexes = {
        @Index(name = "audit_fee_diff_track_detail_index1", columnList = "plan_code"),
        @Index(name = "audit_fee_diff_track_detail_index2", columnList = "detail_code"),
})
public class AuditFeeDiffTrackDetail extends TenantFlagOpEntity {

  @ApiModelProperty("差异费用处理编码")
  @Column(name = "plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '差异费用处理编码'")
  private String planCode;

  @ApiModelProperty("差异费用处理明细编码")
  @Column(name = "detail_code", length = 32, columnDefinition = "varchar(32) COMMENT '差异费用处理明细编码'")
  private String detailCode;
  
  @ApiModelProperty("方案模板编码")
  @Column(name = "template_config_code", length = 128, columnDefinition = "varchar(512) COMMENT '方案模板编码'")
  private String templateConfigCode;
  
  @ApiModelProperty("方案模板名称")
  @Column(name = "template_config_name", length = 512, columnDefinition = "varchar(1024) COMMENT '方案模板名称'")
  private String templateConfigName;

  @ApiModelProperty("申请金额汇总")
  @Column(name = "sales_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '申请金额汇总'")
  private BigDecimal salesAmount;

  @ApiModelProperty(name = " 差异费用来源", notes = "差异费用来源")
  @Column(name = "diff_source", length = 256, columnDefinition = "VARCHAR(256) COMMENT '差异费用来源'")
  private String diffSource;

  @ApiModelProperty("陈列数量")
  @Column(name = "display_number", columnDefinition = "decimal(24,6) COMMENT '陈列数量'")
  private BigDecimal displayNumber;

  @ApiModelProperty("核销金额")
  @Column(name = "audit_amount", length = 20, columnDefinition = "decimal(24,6) COMMENT '核销金额'")
  private BigDecimal auditAmount;

  @ApiModelProperty("门店预计月销售额")
  @Column(name = "terminal_month_sales_amount", columnDefinition = "decimal(24,6) COMMENT '门店预计月销售额'")
  private BigDecimal terminalMonthSalesAmount;

  @ApiModelProperty("是否和价格有关")
  @Column(name = "relate_to_price", length = 10, columnDefinition = "varchar(10) COMMENT '是否和价格有关'")
  private String relateToPrice;

  /**
   * 是否关闭，   Y是N否
   */
  @ApiModelProperty(name = "isClose", notes = "是否关闭", value = "是否关闭，   Y是N否")
  @Column(name = "is_close", nullable = false, length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否关闭 '")
  private String isClose;

  // ---------------------------------------------------------------------------------------------------

  /**
   * 数据字典 interface_push_status
   */
  @ApiModelProperty("SAP推送标记")
  @Column(name = "sap_interface_state", length = 32, columnDefinition = "varchar(32) COMMENT 'SAP推送标记'")
  private String sapInterfaceState;

  /**
   * 数据字典 interface_push_status
   */
  @ApiModelProperty("牛人管家推送标记")
  @Column(name = "cow_manager_state", length = 32, columnDefinition = "varchar(32) COMMENT '牛人管家推送标记'")
  private String cowManagerState;

  /**
   * 数据字典 budget_rollback_status
   */
  @ApiModelProperty("预算回退状态")
  @Column(name = "rollback_budget_tag", length = 32, columnDefinition = "varchar(32) COMMENT '预算回退状态'")
  private String rollbackBudgetTag;

  @ApiModelProperty("预算回退金额")
  @Column(name = "rollback_amount", length = 32, columnDefinition = "decimal(20,6) COMMENT '预算回退金额'")
  private BigDecimal rollbackAmount;

  @ApiModelProperty("销售机构erp编码")
  @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售机构erp编码'")
  private String salesInstitutionErpCode;

  @ApiModelProperty("客户erp编码")
  @Column(name = "customer_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户erp编码'")
  private String customerErpCode;

  @ApiModelProperty("销售组织")
  @Column(name = "activity_org_name", length = 32, columnDefinition = "varchar(32) COMMENT '销售组织'")
  private String activityOrgName;

  @ApiModelProperty("销售组织编码")
  @Column(name = "activity_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售组织编码'")
  private String activityOrgCode;

  @ApiModelProperty("分销渠道")
  @Column(name = "distribution_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道'")
  private String distributionChannelCode;

  @ApiModelProperty("活动便签号")
  @Column(name = "activity_number", length = 32, columnDefinition = "varchar(32) COMMENT '活动便签号'")
  private String activityNumber;

  @ApiModelProperty("活动分类")
  @Column(name = "activity_type_name", length = 64, columnDefinition = "VARCHAR(255) COMMENT '活动分类名称'")
  private String activityTypeName;

  @ApiModelProperty("活动分类编码")
  @Column(name = "activity_type_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动分类编码'")
  private String activityTypeCode;

  @ApiModelProperty("活动形式编码")
  @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
  private String activityFormCode;

  @ApiModelProperty("活动形式")
  @Column(name = "activity_form_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
  private String activityFormName;

  /**
   * 数据字典 MDM_CUSTOMIZE_ORG
   */
  @ApiModelProperty("区域")
  @Column(name = "region", length = 32, columnDefinition = "varchar(32) COMMENT '区域'")
  private String region;

  @ApiModelProperty("零售商")
  @Column(name = "system_name", length = 32, columnDefinition = "varchar(32) COMMENT '零售商'")
  private String systemName;

  @ApiModelProperty("零售商编码")
  @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
  private String systemCode;

  /**
   * 数据字典 warehouse_division
   */
  @ApiModelProperty("AC分仓编码")
  @Column(name = "ac_warehouse_code", length = 32, columnDefinition = "varchar(32) COMMENT 'AC分仓编码'")
  private String acWarehouseCode;

  @ApiModelProperty("AC分仓")
  @Column(name = "ac_warehouse", length = 32, columnDefinition = "varchar(32) COMMENT 'AC分仓'")
  private String acWarehouse;

  /**
   * 数据字典 ac_store_type
   */
  @ApiModelProperty("AC门店类型")
  @Column(name = "ac_store_type", length = 32, columnDefinition = "varchar(32) COMMENT 'AC门店类型'")
  private String acStoreType;

  @ApiModelProperty("一级营销渠道")
  @Column(name = "first_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '一级渠道编码'")
  private String firstChannelCode;

  @ApiModelProperty("二级营销渠道")
  @Column(name = "second_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '二级渠道编码'")
  private String secondChannelCode;

  @ApiModelProperty("一级营销渠道")
  @Column(name = "first_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '一级渠道名称'")
  private String firstChannelName;

  @ApiModelProperty("二级营销渠道")
  @Column(name = "second_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '二级渠道名称'")
  private String secondChannelName;

  /**
   * 数据字典 audit_type
   */
  @ApiModelProperty("核销方式")
  @Column(name = "write_off_method", length = 32, columnDefinition = "varchar(32) COMMENT '核销方式'")
  private String writeOffMethod;

  @ApiModelProperty("品牌名称")
  @Column(name = "product_brand_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '品牌名称'")
  private String productBrandName;

  @ApiModelProperty("品牌编码")
  @Column(name = "product_brand_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
  private String productBrandCode;

  @ApiModelProperty("品项")
  @Column(name = "product_item_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品项名称'")
  private String productItemName;

  @ApiModelProperty("品项编码")
  @Column(name = "product_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码'")
  private String productItemCode;

  @ApiModelProperty("品类")
  @Column(name = "product_category_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品类名称'")
  private String productCategoryName;

  @ApiModelProperty("品类编码")
  @Column(name = "product_category_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码'")
  private String productCategoryCode;

  @ApiModelProperty("本品")
  @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '本品'")
  private String productName;

  @ApiModelProperty("赠品")
  @Column(name = "gift_name", length = 64, columnDefinition = "varchar(64) COMMENT '赠品'")
  private String giftName;

  @ApiModelProperty("活动开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
  private Date activityBeginDate;

  @ApiModelProperty("活动结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "activity_end_date", columnDefinition = "datetime COMMENT '活动结束时间'")
  private Date activityEndDate;

  @ApiModelProperty("订单开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "order_begin_date", columnDefinition = "datetime COMMENT '订单开始时间'")
  private Date orderBeginDate;

  @ApiModelProperty("订单结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "order_end_date", columnDefinition = "datetime COMMENT '订单结束时间'")
  private Date orderEndDate;

  @ApiModelProperty("费用归属年月")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM")
  @Column(name = "fee_year_month", columnDefinition = "datetime COMMENT '费用归属年月'")
  private Date feeYearMonth;

  /**
   * 数据字典 yesOrNo
   */
  @ApiModelProperty("是否大日期")
  @Column(name = "is_big_date", length = 2, columnDefinition = "varchar(2) COMMENT '是否大日期'")
  private String isBigDate;

  /**
   * 数据字典 inventory_type
   */
  @ApiModelProperty("大日期来源")
  @Column(name = "big_date_source", length = 32, columnDefinition = "varchar(32) COMMENT '大日期来源'")
  private String bigDateSource;

  @ApiModelProperty("本品生产日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "this_product_production_date", columnDefinition = "datetime COMMENT '本品生产日期'")
  private Date thisProductProductionDate;

  @ApiModelProperty("赠品生产日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "gift_production_date", columnDefinition = "datetime COMMENT '赠品生产日期'")
  private Date giftProductionDate;

  /**
   * 数据字典 tpm_activity_plan_bonus_type
   */
  @ApiModelProperty("搭赠类型")
  @Column(name = "bonus_type", length = 32, columnDefinition = "varchar(32) COMMENT '搭赠类型'")
  private String bonusType;

  @ApiModelProperty("单件申请费用")
  @Column(name = "single_application_fee", columnDefinition = "decimal(20,4) COMMENT '单件申请费用'")
  private BigDecimal singleApplicationFee;

  @ApiModelProperty("期间促销件数")
  @Column(name = "period_promotional_number", columnDefinition = "decimal(20,4) COMMENT '期间促销件数'")
  private Integer periodPromotionalNumber;

  @ApiModelProperty("期间促销金额")
  @Column(name = "period_promotional_amount", columnDefinition = "decimal(20,4) COMMENT '期间促销金额'")
  private BigDecimal periodPromotionalAmount;

  @ApiModelProperty("费用合计")
  @Column(name = "total_fee_amount", columnDefinition = "decimal(20,6) COMMENT '费用合计'")
  private BigDecimal totalFeeAmount;

  @ApiModelProperty("系统承担比例")
  @Column(name = "system_share", columnDefinition = "decimal(20,4) COMMENT '系统承担比例'")
  private BigDecimal systemShare;

  @ApiModelProperty("系统承担金额")
  @Column(name = "system_borne_amount", columnDefinition = "decimal(20,4) COMMENT '系统承担金额'")
  private BigDecimal systemBorneAmount;

  @ApiModelProperty("我方承担比例")
  @Column(name = "our_proportion", columnDefinition = "decimal(20,4) COMMENT '我方承担比例'")
  private BigDecimal ourProportion;

  @ApiModelProperty("我方承担金额")
  @Column(name = "fee_amount", columnDefinition = "decimal(20,4) COMMENT '我方承担金额'")
  private BigDecimal feeAmount;
  @ApiModelProperty("总部费用预算编码")
  @Column(name = "head_month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部费用预算编码'")
  private String headMonthBudgetCode;
  @ApiModelProperty("公投费用预算编码")
  @Column(name = "region_referendum_month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '公投费用预算编码'")
  private String regionReferendumMonthBudgetCode;
  @ApiModelProperty("自投费用预算编码")
  @Column(name = "region_automatic_month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '自投费用预算编码'")
  private String regionAutomaticMonthBudgetCode;
  @ApiModelProperty("总部费用预算名称")
  @Column(name = "head_budget_item_name", length = 32, columnDefinition = "varchar(32) COMMENT '总部费用预算名称'")
  private String headBudgetItemName;
  @ApiModelProperty("公投费用预算名称")
  @Column(name = "region_referendum_budget_item_name", length = 32, columnDefinition = "varchar(32) COMMENT '公投费用预算名称'")
  private String regionReferendumBudgetItemName;
  @ApiModelProperty("自投费用预算名称")
  @Column(name = "region_automatic_budget_item_name", length = 32, columnDefinition = "varchar(32) COMMENT '自投费用预算名称'")
  private String regionAutomaticBudgetItemName;
  @ApiModelProperty("总部费用")
  @Column(name = "head_fee_amount", length = 32, columnDefinition = "decimal(20,4) COMMENT '总部费用'")
  private BigDecimal headFeeAmount;
  @ApiModelProperty("公投费用")
  @Column(name = "region_referendum_fee_amount", length = 32, columnDefinition = "decimal(20,4) COMMENT '公投费用'")
  private BigDecimal regionReferendumFeeAmount;
  @ApiModelProperty("自投费用")
  @Column(name = "region_automatic_fee_amount", length = 32, columnDefinition = "decimal(20,4) COMMENT '自投费用'")
  private BigDecimal regionAutomaticFeeAmount;
  @ApiModelProperty("系统月计划量")
  @Column(name = "system_monthly_quantity", length = 11, columnDefinition = "int(11) COMMENT '系统月计划量'")
  private Integer systemMonthlyQuantity;
  @ApiModelProperty("是否共用")
  @Column(name = "public_or_not", columnDefinition = "varchar(4) COMMENT '是否共用'")
  private String publicOrNot;
  @ApiModelProperty("门店共用量")
  @Column(name = "store_utility", columnDefinition = "decimal(20,4) COMMENT '门店共用量'")
  private BigDecimal storeUtility;
  @ApiModelProperty("门店共用金额")
  @Column(name = "store_public_amount", columnDefinition = "decimal(20,4) COMMENT '门店共用金额'")
  private BigDecimal storePublicAmount;
  @ApiModelProperty("浮动率")
  @Column(name = "floating_rate", columnDefinition = "decimal(20,4) COMMENT '浮动率'")
  private BigDecimal floatingRate;
  @ApiModelProperty("浮动量")
  @Column(name = "floating_number", columnDefinition = "decimal(20,4) COMMENT '浮动量'")
  private BigDecimal floatingNumber;
  @ApiModelProperty("浮动金额")
  @Column(name = "floating_amount", columnDefinition = "decimal(20,4) COMMENT '浮动金额'")
  private BigDecimal floatingAmount;

  /**
   * 数据字典 tpm_audit_form
   */
  @ApiModelProperty("结案形式")
  @Column(name = "audit_form", length = 32, columnDefinition = "varchar(32) COMMENT '结案形式'")
  private String auditForm;
  @ApiModelProperty("活动描述")
  @Column(name = "activity_desc", columnDefinition = "varchar(1024) COMMENT '活动描述'")
  private String activityDesc;
  @ApiModelProperty("门店编码")
  @Column(name = "terminal_code", length = 64, columnDefinition = "varchar(64) COMMENT '门店编码'")
  private String terminalCode;
  @ApiModelProperty("门店名称")
  @Column(name = "terminal_name", columnDefinition = "varchar(255) COMMENT '门店名称'")
  private String terminalName;
  @ApiModelProperty("售达方编码")
  @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '售达方编码'")
  private String customerCode;

  @ApiModelProperty("售达方名称")
  @Column(name = "customer_name", length = 64, columnDefinition = "varchar(255) COMMENT '售达方名称'")
  private String customerName;

  /**
   * 数据字典 purchase_type
   */
  @ApiModelProperty("采购类型")
  @Column(name = "is_type_of_purchase_no", length = 40, columnDefinition = "varchar(40) COMMENT '采购类型'")
  private String isTypeOfPurchaseNo;
  @ApiModelProperty("物料编码")
  @Column(name = "material_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '物料编码'")
  private String materialCode;
  @ApiModelProperty("物料名称")
  @Column(name = "material_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '物料名称'")
  private String materialName;
  @ApiModelProperty("物料数量")
  @Column(name = "material_quantity", columnDefinition = "int(11) COMMENT '物料数量'")
  private Integer materialQuantity;

  /**
   * 数据字典 whetherScheduleTimeNo
   */
  @ApiModelProperty("是否档期")
  @Column(name = "on_schedule_or_not", length = 32, columnDefinition = "varchar(32) COMMENT '是否档期'")
  private String onScheduleOrNot;

  @ApiModelProperty("档期时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "schedule_time", columnDefinition = "datetime COMMENT '档期时间'")
  private Date scheduleTime;

  @ApiModelProperty("档期名称")
  @Column(name = "schedule_name", length = 32, columnDefinition = "varchar(32) COMMENT '档期名称'")
  private String scheduleName;

  @ApiModelProperty("档期开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "schedule_begin_date", columnDefinition = "datetime COMMENT '档期开始时间'")
  private Date scheduleBeginDate;

  @ApiModelProperty("档期结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "schedule_end_date", columnDefinition = "datetime COMMENT '档期结束时间'")
  private Date scheduleEndDate;

  @ApiModelProperty("合同编码")
  @Column(name = "contract_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '合同编码'")
  private String contractCode;

  @ApiModelProperty("供应商编码")
  @Column(name = "supplier_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码'")
  private String supplierCode;

  @ApiModelProperty("供应商名称")
  @Column(name = "supplier_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商名称'")
  private String supplierName;

  @ApiModelProperty("核销条件编码")
  @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
  private String auditConditionCode;

  /**
   * 数据字典 tpm_audit_type
   */
  @ApiModelProperty("核销条件类型")
  @Column(name = "audit_type", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件类型'")
  private String auditType;

  @ApiModelProperty("核销条件名称")
  @Column(name = "audit_condition_name", length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
  private String auditConditionName;

  @ApiModelProperty(name = "已结案金额" , notes = "已结案金额")
  @Column(name = "already_audit_amount", columnDefinition = "decimal(20,4) COMMENT '已结案金额'")
  private BigDecimal alreadyAuditAmount;

  @ApiModelProperty(name = "是否完全结案" , notes = "是否完全结案")
  @Column(name = "whole_audit", length = 32, columnDefinition = "varchar(32) COMMENT '是否完全结案'")
  private String wholeAudit;

  @ApiModelProperty(name = "零售商渠道" , notes = "零售商渠道")
  @Column(name = "retailer_channel", length = 64, columnDefinition = "varchar(64) COMMENT '零售商渠道'")
  private String retailerChannel;

  // -------------------------------------------------------------------------------------------------------
  // 拓展表字段

  @Transient
  @TableField(exist = false)
  @ApiModelProperty("税率")
  private BigDecimal taxRate;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("原供价（本品）")
  private BigDecimal originalSupplyPrice;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("原未税价格（本品）")
  private BigDecimal originalPriceProduct;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("原供价（赠品）")
  private BigDecimal originalPriceGift;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("原未税价格（赠品）")
  private BigDecimal originalTaxPriceGift;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("促销含税供价")
  private BigDecimal promotionPriceTax;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("促销未税供价")
  private BigDecimal promotionNonTaxPrice;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("零售价")
  private BigDecimal retailPrice;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("促销售价")
  private BigDecimal promotionalPrice;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("本品数量（力度）")
  private Integer quantityThisProduct;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("赠品数量（力度）")
  private Integer giftQuantity;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("原毛利率")
  private BigDecimal originalGrossRate;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("促销毛利率")
  private BigDecimal promotionalGrossRate;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("活动场次（旧）")
  private String activityEventCode;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("场次名称")
  private String activityEventName;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("单价")
  private BigDecimal price;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("未税金额")
  private BigDecimal contractExcludingTax;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("含税金额")
  private BigDecimal contractIncludingTax;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("实际未税金额")
  private BigDecimal amountExcludingTax;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("实际含税金额")
  private BigDecimal amountIncludingTax;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("城市")
  private String cityName;

  /**
   * 数据字典 region_city_level
   */  @Transient
  @TableField(exist = false)
  @ApiModelProperty("城市等级")
  private String cityLevel;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("产品编码")
  private String productCode;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("员工姓名")
  private String nameOfShoppingGuide;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("员工ID")
  private String employeeId;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("扣费细项")
  private String deductionDetails;

  /**
   * 数据字典 tpm_contract_fee_type
   */  @Transient
  @TableField(exist = false)
  @ApiModelProperty("扣费类型")
  private String deductionType;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("扣费标准")
  private String deductionStandard;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("是否回退预算")
  private String isRollbackBudget;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("平台")
  private String platform;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("GMV")
  private BigDecimal gmv;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("费率")
  private BigDecimal feeRate;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("数量")
  private Integer quantity;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("人员标准")
  private String personnelStandards;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("申请金额")
  private BigDecimal applicationAmount;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("费率")
  private String rate;

  /**
   * 数据字典 Purchasemethod
   */  @Transient
  @TableField(exist = false)
  @ApiModelProperty("购买方式")
  private String buyWay;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("月度计划量")
  private BigDecimal monthlyPlannedQuantity;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("投产比")
  private BigDecimal productionRatio;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("活动形式说明")
  private String activityRemark;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("系统主管")
  private String systemSupervisor;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("集群/职能")
  private String functioned;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("省份")
  private String province;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("联系方式")
  private String contactInformation;

  /**
   * 数据字典 naika
   */  @Transient
  @TableField(exist = false)
  @ApiModelProperty("卡片类型")
  private String cardType;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("卡内提数")
  private Integer carnegieNumber;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("卡片含税单价（元）")
  private BigDecimal priceIncludingTax;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("姓名")
  private String milkName;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("职位")
  private String position;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("电话号码")
  private String telephone;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("政策支持")
  private String promotionSupport;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("组合品名称")
  private String productName2;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("组合品编码")
  private String productCode2;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("赠品税率")
  private BigDecimal giftTaxRate;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("陈列单价")
  private BigDecimal displayPrice;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("常温混堆数量")
  private Integer extChar1;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("常温混堆费用")
  private BigDecimal extChar2;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("特仑有机堆头数量")
  private Integer extChar3;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("特仑有机堆头费用")
  private BigDecimal extChar4;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("特仑苏堆头（除特有机）数量")
  private Integer extChar5;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("特仑苏堆头（除特有机）费用")
  private BigDecimal extChar6;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("纯甄堆头（除果粒酸）数量")
  private Integer extChar7;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("纯甄堆头（除果粒酸）费用")
  private BigDecimal extChar8;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("纯甄PET堆头数量")
  private Integer extChar9;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("纯甄PET堆头费用")
  private BigDecimal extChar10;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("真果粒堆头数量")
  private Integer extChar11;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("真果粒堆头费用")
  private BigDecimal extChar12;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("白奶堆头数量")
  private Integer extChar13;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("白奶堆头费用")
  private BigDecimal extChar14;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("生动化陈列数量")
  private Integer extChar15;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("生动化陈列费用")
  private BigDecimal extChar16;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("巨堆数量")
  private Integer extChar17;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("巨堆费用")
  private BigDecimal extChar18;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("包柱数量")
  private Integer extChar19;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("包柱费用")
  private BigDecimal extChar20;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("店中店数量")
  private Integer extChar21;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("店中店费用")
  private BigDecimal extChar22;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("促销墙数量")
  private Integer extChar23;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("促销墙费用")
  private BigDecimal extChar24;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("小货架数量")
  private Integer extChar25;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("小货架费用")
  private BigDecimal extChar26;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("端架数量")
  private Integer extChar27;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("端架费用")
  private BigDecimal extChar28;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("冷风柜数量")
  private Integer extChar29;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("冷风柜费用")
  private BigDecimal extChar30;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("儿童奶系统堆头数量")
  private Integer extChar31;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("儿童奶系统堆头费用")
  private BigDecimal extChar32;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("果缤纷费用")
  private Integer extChar34;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("果缤纷数量")
  private BigDecimal extChar33;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("长桌数量")
  private Integer extChar35;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("长桌费用")
  private BigDecimal extChar36;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("短桌数量")
  private Integer extChar37;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("短桌费用")
  private BigDecimal extChar38;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("其他陈列数量")
  private Integer extChar39;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("其他陈列费用")
  private BigDecimal extChar40;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("责任业务")
  private String responsibleBusiness;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("责任督导")
  private String responsibleSupervision;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("身份证号码")
  private String personIdCard;

  /**
   * 数据字典 activity_org_subdivision_code
   */  @Transient
  @TableField(exist = false)
  @ApiModelProperty("区域细分")
  private String activityOrgSubdivisionCode;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("本品单位")
  private String productUnit;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("系统门店计划量")
  private Integer systemStoresQuantity;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("城市经理")
  private String cityManager;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("未含税单价")
  private BigDecimal priceExcludingTax;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("陈列数量")
  private Integer displayQuantity;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("申请金额")
  private BigDecimal applyAmount;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("手续费点数")
  private BigDecimal commissionPoint;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("手续费金额")
  private BigDecimal commissionAmount;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("赠品编码")
  private String giftCode;
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("本品数量")
  private Integer productQuantity;
}
