package com.biz.crm.tpm.business.audit.fee.local.entity.track;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Getter;
import lombok.Setter;

/**
 * @author liyang
 * @date 2023/10/05
 */
@ApiModel(value = "AuditFeeDiffTrackDetailExtend", description = "核销差异费用追踪细案拓展")
@TableName("tpm_audit_fee_diff_track_detail_extend")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_track_detail_extend")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_track_detail_extend", comment = "核销差异费用追踪细案拓展")
@Table(name = "tpm_audit_fee_diff_track_detail_extend")
public class AuditFeeDiffTrackDetailExtend extends UuidEntity {
  @ApiModelProperty("税率")
  @Column(name = "tax_rate", columnDefinition = "decimal(20,4) COMMENT '税率'")
  private BigDecimal taxRate;

  @ApiModelProperty("原供价（本品）")
  @Column(name = "original_supply_price", columnDefinition = "decimal(20,4) COMMENT '原供价（本品）'")
  private BigDecimal originalSupplyPrice;

  @ApiModelProperty("原未税价格（本品）")
  @Column(name = "original_price_product", columnDefinition = "decimal(20,4) COMMENT '原未税价格（本品）'")
  private BigDecimal originalPriceProduct;

  @ApiModelProperty("原供价（赠品）")
  @Column(name = "original_price_gift", columnDefinition = "decimal(20,4) COMMENT '原未税价格（赠品）'")
  private BigDecimal originalPriceGift;

  @ApiModelProperty("原未税价格（赠品）")
  @Column(name = "original_tax_price_gift", columnDefinition = "decimal(20,4) COMMENT '原未税价格（赠品）'")
  private BigDecimal originalTaxPriceGift;

  @ApiModelProperty("促销含税供价")
  @Column(name = "promotion_price_tax", columnDefinition = "decimal(20,4) COMMENT '促销含税供价'")
  private BigDecimal promotionPriceTax;

  @ApiModelProperty("促销未税供价")
  @Column(name = "promotion_non_tax_price", columnDefinition = "decimal(20,4) COMMENT '促销未税供价'")
  private BigDecimal promotionNonTaxPrice;

  @ApiModelProperty("零售价")
  @Column(name = "retail_price", columnDefinition = "decimal(20,4) COMMENT '零售价'")
  private BigDecimal retailPrice;

  @ApiModelProperty("促销售价")
  @Column(name = "promotional_price", columnDefinition = "decimal(20,4) COMMENT '促销售价'")
  private BigDecimal promotionalPrice;

  @ApiModelProperty("本品数量（力度）")
  @Column(name = "quantity_this_product", length = 32, columnDefinition = "int(11) COMMENT '本品数量（力度）'")
  private Integer quantityThisProduct;

  @ApiModelProperty("赠品数量（力度）")
  @Column(name = "gift_quantity", length = 32, columnDefinition = "int(11) COMMENT '赠品数量（力度）'")
  private Integer giftQuantity;

  @ApiModelProperty("原毛利率")
  @Column(name = "original_gross_rate", columnDefinition = "decimal(20,4) COMMENT '原毛利率'")
  private BigDecimal originalGrossRate;

  @ApiModelProperty("促销毛利率")
  @Column(name = "promotional_gross_rate", columnDefinition = "decimal(20,4) COMMENT '促销毛利率'")
  private BigDecimal promotionalGrossRate;

  @ApiModelProperty("活动场次（旧）")
  @Column(name = "activity_event_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动场次（旧）'")
  private String activityEventCode;

  @ApiModelProperty("场次名称")
  @Column(name = "activity_event_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '场次名称'")
  private String activityEventName;

  @ApiModelProperty("单价")
  @Column(name = "price", columnDefinition = "decimal(20,4) COMMENT '单价'")
  private BigDecimal price;

  @ApiModelProperty("未税金额")
  @Column(name = "contract_excluding_tax", columnDefinition = "decimal(20,4) COMMENT '未税金额'")
  private BigDecimal contractExcludingTax;

  @ApiModelProperty("含税金额")
  @Column(name = "contract_including_tax", columnDefinition = "decimal(20,4) COMMENT '含税金额'")
  private BigDecimal contractIncludingTax;

  @ApiModelProperty("实际未税金额")
  @Column(name = "amount_excluding_tax", columnDefinition = "decimal(20,4) COMMENT '实际未税金额'")
  private BigDecimal amountExcludingTax;

  @ApiModelProperty("实际含税金额")
  @Column(name = "amount_including_tax", columnDefinition = "decimal(20,4) COMMENT '实际含税金额'")
  private BigDecimal amountIncludingTax;

  @ApiModelProperty("城市")
  @Column(name = "city_name", length = 32, columnDefinition = "varchar(32) COMMENT '城市'")
  private String cityName;

  /**
   * 数据字典 region_city_level
   */
  @ApiModelProperty("城市等级")
  @Column(name = "city_level", length = 32, columnDefinition = "varchar(32) COMMENT '城市等级'")
  private String cityLevel;

  @ApiModelProperty("产品编码")
  @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
  private String productCode;

  @ApiModelProperty("员工姓名")
  @Column(name = "name_of_shopping_guide", length = 32, columnDefinition = "varchar(32) COMMENT '员工姓名'")
  private String nameOfShoppingGuide;

  @ApiModelProperty("员工ID")
  @Column(name = "employee_id", length = 32, columnDefinition = "varchar(32) COMMENT '员工ID'")
  private String employeeId;

  @ApiModelProperty("扣费细项")
  @Column(name = "deduction_details", length = 255, columnDefinition = "varchar(255) COMMENT '扣费细项'")
  private String deductionDetails;

  /**
   * 数据字典 tpm_contract_fee_type
   */
  @ApiModelProperty("扣费类型")
  @Column(name = "deduction_type", length = 32, columnDefinition = "varchar(255) COMMENT '扣费类型'")
  private String deductionType;

  @ApiModelProperty("扣费标准")
  @Column(name = "deduction_standard", length = 32, columnDefinition = "VARCHAR(256) COMMENT '扣费标准'")
  private String deductionStandard;

  @ApiModelProperty("是否回退预算")
  @Column(name = "is_rollback_budget", length = 10, columnDefinition = "VARCHAR(5) COMMENT '是否回退预算： Y是N否'")
  private String isRollbackBudget;

  @ApiModelProperty("平台")
  @Column(name = "platform", length = 10, columnDefinition = "VARCHAR(5) COMMENT '是否回退预算： Y是N否'")
  private String platform;

  @ApiModelProperty("GMV")
  @Column(name = "gmv", columnDefinition = "decimal(20,4) COMMENT 'GMV'")
  private BigDecimal gmv;

  @ApiModelProperty("费率")
  @Column(name = "fee_rate", columnDefinition = "decimal(20,4) COMMENT '费率'")
  private BigDecimal feeRate;

  @ApiModelProperty("数量")
  @Column(name = "quantity", columnDefinition = "int(11) COMMENT '数量'")
  private Integer quantity;

  @ApiModelProperty("人员标准")
  @Column(name = "personnel_standards", length = 32, columnDefinition = "varchar(32) COMMENT '人员标准'")
  private String personnelStandards;

  @ApiModelProperty("申请金额")
  @Column(name = "application_amount", columnDefinition = "decimal(24,6) COMMENT '申请金额'")
  private BigDecimal applicationAmount;

  @ApiModelProperty("费率")
  @Column(name = "rate", columnDefinition = "decimal(20,4) COMMENT '费率'")
  private String rate;

  /**
   * 数据字典 Purchasemethod
   */
  @ApiModelProperty("购买方式")
  @Column(name = "buy_way", length = 32, columnDefinition = "varchar(32) COMMENT '购买方式'")
  private String buyWay;

  @ApiModelProperty("月度计划量")
  @Column(name = "monthly_planned_quantity", length = 32, columnDefinition = "int(11) COMMENT '月度计划量'")
  private BigDecimal monthlyPlannedQuantity;

  @ApiModelProperty("投产比")
  @Column(name = "production_ratio", length = 32, columnDefinition = "int(11) COMMENT '投产比'")
  private BigDecimal productionRatio;

  @ApiModelProperty("活动形式说明")
  @Column(name = "activity_remark", length = 32, columnDefinition = "varchar(32) COMMENT '活动形式说明'")
  private String activityRemark;

  @ApiModelProperty("系统主管")
  @Column(name = "system_supervisor", length = 32, columnDefinition = "varchar(32) COMMENT '系统主管'")
  private String systemSupervisor;

  @ApiModelProperty("集群/职能")
  @Column(name = "functioned", length = 32, columnDefinition = "varchar(32) COMMENT '集群/职能'")
  private String functioned;

  @ApiModelProperty("省份")
  @Column(name = "province", length = 32, columnDefinition = "varchar(32) COMMENT '省份'")
  private String province;

  @ApiModelProperty("联系方式")
  @Column(name = "contact_information", length = 32, columnDefinition = "varchar(32) COMMENT '联系方式'")
  private String contactInformation;

  /**
   * 数据字典 naika
   */
  @ApiModelProperty("卡片类型")
  @Column(name = "card_type", length = 32, columnDefinition = "varchar(32) COMMENT '卡片类型'")
  private String cardType;

  @ApiModelProperty("卡内提数")
  @Column(name = "carnegie_number", columnDefinition = "int(11)  COMMENT '卡内提数'")
  private Integer carnegieNumber;

  @ApiModelProperty("卡片含税单价（元）")
  @Column(name = "price_including_tax", columnDefinition = "decimal(20,4) COMMENT '卡片含税单价（元）'")
  private BigDecimal priceIncludingTax;

  @ApiModelProperty("姓名")
  @Column(name = "milk_name", length = 32, columnDefinition = "varchar(32) COMMENT '姓名'")
  private String milkName;

  @ApiModelProperty("职位")
  @Column(name = "position", length = 32, columnDefinition = "varchar(32) COMMENT '职位'")
  private String position;

  @ApiModelProperty("电话号码")
  @Column(name = "telephone", length = 32, columnDefinition = "varchar(32) COMMENT '电话号码'")
  private String telephone;

  @ApiModelProperty("政策支持")
  @Column(name = "promotion_support", length = 32, columnDefinition = "varchar(32) COMMENT '政策支持'")
  private String promotionSupport;

  @ApiModelProperty("组合品名称")
  @Column(name = "product_name2", length = 32, columnDefinition = "varchar(32) COMMENT '组合品名称'")
  private String productName2;

  @ApiModelProperty("组合品编码")
  @Column(name = "product_code2", length = 32, columnDefinition = "varchar(32) COMMENT '组合品编码'")
  private String productCode2;

  @ApiModelProperty("赠品税率")
  @Column(name = "gift_tax_rate", columnDefinition = "decimal(20,4) COMMENT '赠品税率'")
  private BigDecimal giftTaxRate;

  @ApiModelProperty("陈列单价")
  @Column(name = "display_price", columnDefinition = "decimal(20,4) COMMENT '陈列单价'")
  private BigDecimal displayPrice;

  @ApiModelProperty("常温混堆数量")
  @Column(name = "ext_char1", columnDefinition = "int(11) COMMENT '常温混堆数量'")
  private Integer extChar1;

  @ApiModelProperty("常温混堆费用")
  @Column(name = "ext_char2", columnDefinition = "decimal(20,4) COMMENT '常温混堆费用'")
  private BigDecimal extChar2;

  @ApiModelProperty("特仑有机堆头数量")
  @Column(name = "ext_char3", columnDefinition = "int(11) COMMENT '特仑有机堆头数量'")
  private Integer extChar3;

  @ApiModelProperty("特仑有机堆头费用")
  @Column(name = "ext_char4", columnDefinition = "decimal(20,4) COMMENT '特仑有机堆头费用'")
  private BigDecimal extChar4;

  @ApiModelProperty("特仑苏堆头（除特有机）数量")
  @Column(name = "ext_char5", columnDefinition = "int(11) COMMENT '特仑苏堆头（除特有机）数量'")
  private Integer extChar5;

  @ApiModelProperty("特仑苏堆头（除特有机）费用")
  @Column(name = "ext_char6", columnDefinition = "decimal(20,4) COMMENT '特仑苏堆头（除特有机）费用'")
  private BigDecimal extChar6;

  @ApiModelProperty("纯甄堆头（除果粒酸）数量")
  @Column(name = "ext_char7", columnDefinition = "int(11) COMMENT '纯甄堆头（除果粒酸）数量'")
  private Integer extChar7;

  @ApiModelProperty("纯甄堆头（除果粒酸）费用")
  @Column(name = "ext_char8", columnDefinition = "decimal(20,4) COMMENT '纯甄堆头（除果粒酸）费用'")
  private BigDecimal extChar8;

  @ApiModelProperty("纯甄PET堆头数量")
  @Column(name = "ext_char9", columnDefinition = "int(11) COMMENT '纯甄PET堆头数量'")
  private Integer extChar9;

  @ApiModelProperty("纯甄PET堆头费用")
  @Column(name = "ext_char10", columnDefinition = "decimal(20,4) COMMENT '纯甄PET堆头费用'")
  private BigDecimal extChar10;

  @ApiModelProperty("真果粒堆头数量")
  @Column(name = "ext_char11", columnDefinition = "int(11) COMMENT '真果粒堆头数量'")
  private Integer extChar11;

  @ApiModelProperty("真果粒堆头费用")
  @Column(name = "ext_char12", columnDefinition = "decimal(20,4) COMMENT '真果粒堆头费用'")
  private BigDecimal extChar12;

  @ApiModelProperty("白奶堆头数量")
  @Column(name = "ext_char13", columnDefinition = "int(11) COMMENT '白奶堆头数量'")
  private Integer extChar13;

  @ApiModelProperty("白奶堆头费用")
  @Column(name = "ext_char14", columnDefinition = "decimal(20,4) COMMENT '白奶堆头费用'")
  private BigDecimal extChar14;

  @ApiModelProperty("生动化陈列数量")
  @Column(name = "ext_char15", columnDefinition = "int(11) COMMENT '生动化陈列数量'")
  private Integer extChar15;

  @ApiModelProperty("生动化陈列费用")
  @Column(name = "ext_char16", columnDefinition = "decimal(20,4) COMMENT '生动化陈列费用'")
  private BigDecimal extChar16;

  @ApiModelProperty("巨堆数量")
  @Column(name = "ext_char17", columnDefinition = "int(11) COMMENT '巨堆数量'")
  private Integer extChar17;

  @ApiModelProperty("巨堆费用")
  @Column(name = "ext_char18", columnDefinition = "decimal(20,4) COMMENT '巨堆费用'")
  private BigDecimal extChar18;

  @ApiModelProperty("包柱数量")
  @Column(name = "ext_char19", columnDefinition = "int(11) COMMENT '包柱数量'")
  private Integer extChar19;

  @ApiModelProperty("包柱费用")
  @Column(name = "ext_char20", columnDefinition = "decimal(20,4) COMMENT '包柱费用'")
  private BigDecimal extChar20;

  @ApiModelProperty("店中店数量")
  @Column(name = "ext_char21", columnDefinition = "int(11) COMMENT '店中店数量'")
  private Integer extChar21;

  @ApiModelProperty("店中店费用")
  @Column(name = "ext_char22", columnDefinition = "decimal(20,4) COMMENT '店中店费用'")
  private BigDecimal extChar22;

  @ApiModelProperty("促销墙数量")
  @Column(name = "ext_char23", columnDefinition = "int(11) COMMENT '促销墙数量'")
  private Integer extChar23;

  @ApiModelProperty("促销墙费用")
  @Column(name = "ext_char24", columnDefinition = "decimal(20,4) COMMENT '促销墙费用'")
  private BigDecimal extChar24;

  @ApiModelProperty("小货架数量")
  @Column(name = "ext_char25", columnDefinition = "int(11) COMMENT '小货架数量'")
  private Integer extChar25;

  @ApiModelProperty("小货架费用")
  @Column(name = "ext_char26", columnDefinition = "decimal(20,4) COMMENT '小货架费用'")
  private BigDecimal extChar26;

  @ApiModelProperty("端架数量")
  @Column(name = "ext_char27", columnDefinition = "int(11) COMMENT '端架数量'")
  private Integer extChar27;

  @ApiModelProperty("端架费用")
  @Column(name = "ext_char28", columnDefinition = "decimal(20,4) COMMENT '端架费用'")
  private BigDecimal extChar28;

  @ApiModelProperty("冷风柜数量")
  @Column(name = "ext_char29", columnDefinition = "int(11) COMMENT '冷风柜数量'")
  private Integer extChar29;

  @ApiModelProperty("冷风柜费用")
  @Column(name = "ext_char30", columnDefinition = "decimal(20,4) COMMENT '冷风柜费用'")
  private BigDecimal extChar30;

  @ApiModelProperty("儿童奶系统堆头数量")
  @Column(name = "ext_char31", columnDefinition = "int(11) COMMENT '儿童奶系统堆头数量'")
  private Integer extChar31;

  @ApiModelProperty("儿童奶系统堆头费用")
  @Column(name = "ext_char32", columnDefinition = "decimal(20,4) COMMENT '儿童奶系统堆头费用'")
  private BigDecimal extChar32;

  @ApiModelProperty("果缤纷费用")
  @Column(name = "ext_char34", columnDefinition = "int(11) COMMENT '果缤纷费用'")
  private Integer extChar34;

  @ApiModelProperty("果缤纷数量")
  @Column(name = "ext_char33", columnDefinition = "decimal(20,4) COMMENT '果缤纷数量'")
  private BigDecimal extChar33;

  @ApiModelProperty("长桌数量")
  @Column(name = "ext_char35", columnDefinition = "int(11) COMMENT '长桌数量'")
  private Integer extChar35;

  @ApiModelProperty("长桌费用")
  @Column(name = "ext_char36", columnDefinition = "decimal(20,4) COMMENT '长桌费用'")
  private BigDecimal extChar36;

  @ApiModelProperty("短桌数量")
  @Column(name = "ext_char37", columnDefinition = "int(11) COMMENT '短桌数量'")
  private Integer extChar37;

  @ApiModelProperty("短桌费用")
  @Column(name = "ext_char38", columnDefinition = "decimal(20,4) COMMENT '短桌费用'")
  private BigDecimal extChar38;

  @ApiModelProperty("其他陈列数量")
  @Column(name = "ext_char39", columnDefinition = "int(11) COMMENT '其他陈列数量'")
  private Integer extChar39;

  @ApiModelProperty("其他陈列费用")
  @Column(name = "ext_char40", columnDefinition = "decimal(20,4) COMMENT '其他陈列费用'")
  private BigDecimal extChar40;

  @ApiModelProperty("责任业务")
  @Column(name = "responsible_business", length = 32, columnDefinition = "varchar(32) COMMENT '责任业务'")
  private String responsibleBusiness;

  @ApiModelProperty("责任督导")
  @Column(name = "responsible_supervision", length = 32, columnDefinition = "varchar(32) COMMENT '责任督导'")
  private String responsibleSupervision;

  @ApiModelProperty("身份证号码")
  @Column(name = "person_id_card", length = 32, columnDefinition = "varchar(32) COMMENT '身份证号码'")
  private String personIdCard;

  /**
   * 数据字典 activity_org_subdivision_code
   */
  @ApiModelProperty("区域细分")
  @Column(name = "activity_org_subdivision_code", length = 32, columnDefinition = "varchar(32) COMMENT '区域细分'")
  private String activityOrgSubdivisionCode;

  @ApiModelProperty("本品单位")
  @Column(name = "product_unit", length = 32, columnDefinition = "varchar(32) COMMENT '本品单位'")
  private String productUnit;

  @ApiModelProperty("系统门店计划量")
  @Column(name = "system_stores_quantity", columnDefinition = "int(11) COMMENT '系统门店计划量'")
  private Integer systemStoresQuantity;

  @ApiModelProperty("城市经理")
  @Column(name = "city_manager", length = 32, columnDefinition = "varchar(32) COMMENT '城市经理'")
  private String cityManager;

  @ApiModelProperty("未含税单价")
  @Column(name = "price_excluding_tax", columnDefinition = "decimal(20,4) COMMENT '未含税单价'")
  private BigDecimal priceExcludingTax;

  @ApiModelProperty("陈列数量")
  @Column(name = "display_quantity", columnDefinition = "int(11) COMMENT '陈列数量'")
  private Integer displayQuantity;

  @ApiModelProperty("申请金额")
  @Column(name = "apply_amount", columnDefinition = "decimal(20,4) COMMENT '申请金额'")
  private BigDecimal applyAmount;

  @ApiModelProperty("手续费点数")
  @Column(name = "commission_point", columnDefinition = "decimal(20,4) COMMENT '手续费点数'")
  private BigDecimal commissionPoint;

  @ApiModelProperty("手续费金额")
  @Column(name = "commission_amount", columnDefinition = "decimal(20,4) COMMENT '手续费金额'")
  private BigDecimal commissionAmount;

  @ApiModelProperty("赠品编码")
  @Column(name = "gift_code", length = 32, columnDefinition = "varchar(32) COMMENT '赠品编码'")
  private String giftCode;

  @ApiModelProperty("本品数量")
  @Column(name = "product_quantity", columnDefinition = "int(11) COMMENT '本品数量'")
  private Integer productQuantity;
}
