package com.biz.crm.tpm.business.audit.fee.local.entity.track;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author liyang
 * @date 2023/09/28
 * @description：差异费用追踪详情差异费用台账
 */
@ApiModel(value = "AuditFeeDiffTrackDetailLedger", description = "差异费用追踪详情差异费用台账")
@TableName("tpm_audit_fee_diff_track_detail_ledger")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_track_detail_ledger")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_track_detail_ledger", comment = "差异费用追踪详情差异费用台账")
@Table(name = "tpm_audit_fee_diff_track_detail_ledger")
public class AuditFeeDiffTrackDetailLedger extends TenantFlagOpEntity {

    @ApiModelProperty("差异费用处理编码")
    @Column(name = "plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '差异费用处理编码'")
    private String planCode;

    @ApiModelProperty("差异费用处理明细编码")
    @Column(name = "detail_code", length = 32, columnDefinition = "varchar(32) COMMENT '差异费用处理明细编码'")
    private String detailCode;

    @ApiModelProperty(name = "auditFeeCheckCode", notes = "核销费用核对表扣费匹配单号")
    @Column(name = "audit_fee_check_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销费用核对表扣费匹配单号'")
    private String auditFeeCheckCode;

    @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用编码")
    @Column(name = "fee_diff_ledger_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '差异费用编码'")
    private String feeDiffLedgerCode;

    /**
     * 状态
     */
    @ApiModelProperty(name = "status", notes = "状态[字典：audit_fee_diff_status]")
    @Column(name = "status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '状态[字典：audit_fee_diff_status]'")
    private String status;

    /**
     * 年份
     */
    @ApiModelProperty(name = "year", notes = "年份")
    @Column(name = "year", length = 32, columnDefinition = "VARCHAR(6) COMMENT '年份'")
    private String year;

    /**
     * 月份
     */
    @ApiModelProperty(name = "月份", notes = "月份")
    @Column(name = "month", length = 32, columnDefinition = "VARCHAR(4) COMMENT '月份'")
    private String month;

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @Column(name = "fee_year_month", length = 20, columnDefinition = "VARCHAR(8) COMMENT '费用所属年月 '")
    private String feeYearMonth;
    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "salesOrgCode", notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "salesOrgName", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    /**
     * 业务区域编码
     */
    @ApiModelProperty(name = "businessAreaCode", notes = "业务区域编码")
    @Column(name = "business_area_code", length = 32, columnDefinition = "VARCHAR(10) COMMENT '业务区域编码'")
    private String businessAreaCode;

    /**
     * 业务区域名称
     */
    @ApiModelProperty(name = "businessAreaName", value = "业务区域名称")
    @Column(name = "business_area_name", length = 255, columnDefinition = "VARCHAR(10) COMMENT '业务区域名称'")
    private String businessAreaName;


    @ApiModelProperty(name = "零售商编码")
    @Column(name = "retailer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商编码'")
    private String retailerCode;

    @ApiModelProperty(name = "零售商名称")
    @Column(name = "retailer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '零售商名称'")
    private String retailerName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    @Column(name = "sold_to_party_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方编码'")
    private String soldToPartyCode;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    @Column(name = "sold_to_party_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '售达方名称'")
    private String soldToPartyName;

    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    @Column(name = "delivery_party_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方编码'")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    @Column(name = "delivery_party_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '售达方名称'")
    private String deliveryPartyName;

    /**
     * 活动分类
     */
    @ApiModelProperty(name = "activitiesType", notes = "活动分类")
    @Column(name = "activities_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动分类 '")
    private String activitiesType;

    /**
     * 活动分类
     */
    @ApiModelProperty(name = "activitiesTypeName", notes = "活动分类名称")
    @Column(name = "activities_type_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动分类 '")
    private String activitiesTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "activityFormCode", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动形式编码 '")
    private String activity_form_code;

    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "activityFormName", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式名称 '")
    private String activity_form_name;

    /**
     * 差异金额
     */
    @ApiModelProperty(name = "diffAmount", notes = "差异金额", value = "差异金额")
    @Column(name = "diff_amount", columnDefinition = "Decimal(24,6) COMMENT '差异金额 '")
    private BigDecimal diffAmount;


    /**
     * 已追回金额
     */
    @ApiModelProperty(name = "recoveredAmount", notes = "已追回金额", value = "已追回金额")
    @Column(name = "recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '已追回金额 '")
    private BigDecimal recoveredAmount;

    /**
     * 待追回金额
     */
    @ApiModelProperty(name = "beRecoveredAmount", notes = "待追回金额", value = "待追回金额")
    @Column(name = "be_recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '待追回金额 '")
    private BigDecimal beRecoveredAmount;

    /**
     * 使用金额
     */
    @ApiModelProperty(name = "usedAmount", notes = "使用金额", value = "使用金额")
    @Column(name = "used_amount", columnDefinition = "Decimal(24,6) COMMENT '使用金额 '")
    private BigDecimal usedAmount;

    /**
     * 跟进人
     */
    @ApiModelProperty(name = "followUpPerson", notes = "跟进人", value = "跟进人")
    @Column(name = "follow_up_person", length = 64, columnDefinition = "VARCHAR(64) COMMENT '跟进人 '")
    private String followUpPerson;

    /**
     * 完全追回时间
     */
    @ApiModelProperty(name = "recoveredTime", notes = "完全追回时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "recovered_time",  columnDefinition = "datetime COMMENT '完全追回时间(yyyy-MM-dd HH:mm:ss)'")
    private Date recoveredTime;

    /**
     * 零售确认差异金额
     */
    @ApiModelProperty(name = "confirmDiffAmount", notes = "零售确认差异金额", value = "零售确认差异金额")
    @Column(name = "confirm_diff_amount", columnDefinition = "Decimal(24,6) COMMENT '确认差异金额 '")
    private BigDecimal confirmDiffAmount;

    /**
     * 是否影响结算
     */
    @ApiModelProperty(name = "isEffectStatement", notes = "是否影响结算", value = "是否影响结算")
    @Column(name = "is_effect_statement", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否影响结算'")
    private String isEffectStatement;
}
