package com.biz.crm.tpm.business.audit.fee.local.event.check;

import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditCheckEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.check.AuditFeeCheckEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @Description:核销费用核对主表变更事件通知接口
 * @Author qiancheng
 * @Date 2023/5/27
 */
@Slf4j
@Component
public class AuditFeeCheckEventListenerImpl implements AuditFeeCheckEventListener {

    @Autowired(required = false)
    private AuditFeeCheckRepository auditFeeCheckRepository;

    /**
     * 差异费用处理数据删除时触发
     *
     * @param matchCodes
     */
    @Override
    public void diffDisposeDeleted(AuditCheckEventDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty(dto.getMatchCodes())) {
            return;
        }
        auditFeeCheckRepository.diffDisposeDeletedUpdateStatus(dto.getMatchCodes());
    }
}
