package com.biz.crm.tpm.business.audit.fee.local.helper;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.alibaba.excel.util.Validate;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerItemDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @Description 差异费用处理助手
 * @Author YangWei
 * @Date 2023/3/24 下午3:36
 */
@Slf4j
@Component
public class AuditFeeDiffDisposeHelper {

    @Autowired
    private AuditFeeDiffDisposeDetailVoService auditFeeDiffDisposeDetailVoService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 非空校验
     * @param dto
     */
    public void verifyEmpty(AuditFeeDiffDisposeDto dto) {
        Assert.notNull(dto, "参数不能为空");
        Assert.hasText(dto.getBusinessFormatCode(), "业态不能为空");
        Assert.hasText(dto.getBusinessUnitCode(), "业务单元不能为空");
        Assert.hasText(dto.getFeeDiffDisposeName(), "处理名称不能为空");
        Assert.notNull(dto.getDisposeFeeAmount(), "汇总金额不能为空");
        Assert.notEmpty(dto.getTemplates(), "模版不能为空");
    }

    /**
     * 构建明细
     * @param cacheKey
     * @param dto
     * @return {@link List}<{@link AuditFeeDiffDisposeDetailDto}>
     */
    public void buildDetails(String cacheKey, AuditFeeDiffDisposeDto dto) {
        if(StringUtils.hasText(cacheKey)) {
            List<AuditFeeDiffDisposeDetailDto> detailDtos = Lists.newArrayList();
            //差异费用明细
            List<AuditFeeDiffDisposeLedgerItemDto> ledgerItemDtos = Lists.newArrayList();
            for (AuditFeeDiffDisposeTemplateVo template : dto.getTemplates()) {
                String redisKey = cacheKey + ":" + template.getTemplateConfigCode();
                List<AuditFeeDiffDisposeDetailDto> cacheDetailDtos = this.auditFeeDiffDisposeDetailVoService.findCacheList(redisKey);
                if (!CollectionUtils.isEmpty(cacheDetailDtos)) {
                    List<AuditFeeDiffDisposeDetailDto> noItemCodes = cacheDetailDtos.stream().filter(o -> !StringUtils.hasText(o.getDetailPlanItemCode())).collect(Collectors.toList());
                    List<String> codes = this.generateDetailCodes(noItemCodes.size());
                    AtomicReference<Integer> i = new AtomicReference<>(0);
                    cacheDetailDtos.forEach(o -> {
                        BigDecimal thisUseAmount = Optional.ofNullable(o.getThisUseAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal totalFeeAmount = BigDecimal.ZERO;
                        if (!org.apache.commons.lang3.StringUtils.isBlank(o.getTotalFeeAmountStr())){
                            try {
                                totalFeeAmount = new BigDecimal(o.getTotalFeeAmountStr().trim());
                            } catch (Exception e) {
                                throw new IllegalArgumentException("请填写正确的费用合计["+o.getTotalFeeAmountStr()+"]");
                            }
                        }
                        Validate.isTrue(thisUseAmount.compareTo(totalFeeAmount) == 0, "'费用合计' 与 '差异费用汇总（元）'必须相同");
                        o.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
                        o.setFeeDiffDisposeName(dto.getFeeDiffDisposeName());
                        o.setTemplateConfigCode(template.getTemplateConfigCode());
                        o.setTemplateConfigName(template.getTemplateConfigName());
                        if(!StringUtils.hasText(o.getDetailPlanItemCode())){
                            o.setDetailPlanItemCode(codes.get(i.get()));
                            i.set(i.get() + 1);
                        }
                        //关联差异费用明细
                        List<AuditFeeDiffDisposeLedgerItemDto> ledgerItems = o.getLedgerItems();
                        Assert.notEmpty(ledgerItems, "差异费用台帐明细不能为空");
                        ledgerItems.forEach(ledgerItem -> {
                            AuditFeeDiffDisposeLedgerItemDto itemDto = this.nebulaToolkitService
                                .copyObjectByBlankList(ledgerItem, AuditFeeDiffDisposeLedgerItemDto.class, HashSet.class, ArrayList.class);
                            itemDto.setDetailPlanItemCode(o.getDetailPlanItemCode());
                            itemDto.setFeeDiffDisposeCode(o.getFeeDiffDisposeCode());
                            itemDto.setFeeYearMonth(DateUtil.format(o.getFeeYearMonth(), DatePattern.NORM_MONTH_PATTERN));
                            ledgerItemDtos.add(itemDto);
                        });
                    });
                    detailDtos.addAll(cacheDetailDtos);
                }
            }
            dto.setDetails(detailDtos);
            dto.setLedgerItems(ledgerItemDtos);
            this.auditFeeDiffDisposeDetailVoService.clearCache(cacheKey);
        }else{
            //生成编码
            List<String> codes = this.generateDetailCodes(dto.getDetails().size());
            AtomicReference<Integer> i = new AtomicReference<>(0);
            dto.getDetails().forEach(o -> {
                o.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
                o.setFeeDiffDisposeName(dto.getFeeDiffDisposeName());
                Assert.hasText(o.getTemplateConfigCode(), "模版编码不能为空");
                Assert.hasText(o.getTemplateConfigCode(), "模版名称不能为空");
                o.setDetailPlanItemCode(codes.get(i.get()));
                i.set(i.get() + 1);
            });
        }
    }

    /**
     * 明细编码
     * @param number
     * @return {@link List}<{@link String}>
     */
    private List<String> generateDetailCodes(Integer number) {
//        String ruleCode = org.apache.commons.lang3.StringUtils.join(AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE_DETAIL, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        return generateCodeService.generateCode(AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE_DETAIL, number);
    }

    /**
     * 头编码
     * @param
     * @return {@link String}
     */
    public String generateCode() {
        //生成编码
//        String ruleCode = org.apache.commons.lang3.StringUtils.join(AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        return generateCodeService.generateCode(AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE, 1).get(0);
    }
}