package com.biz.crm.tpm.business.audit.fee.local.helper;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONArray;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeSettlementConstant;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @Description
 * @Author zhouYang
 * @Date 2023/09/28
 */
@Slf4j
@Component
public class AuditFeeSettlementCheckDetailPlanHelper extends MnPageCacheHelper<AuditFeeSettlementCheckDetailPlanVo, AuditFeeSettlementCheckDetailPlanDto> {

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private AuditFeeSettlementCheckDetailPlanRepository detailPlanRepository;

    @Override
    public String getCacheKeyPrefix() {
        return AuditFeeSettlementConstant.CACHE_PREFIX_DETAIL_PLAN;
    }

    @Override
    public Class<AuditFeeSettlementCheckDetailPlanDto> getDtoClass() {
        return AuditFeeSettlementCheckDetailPlanDto.class;
    }

    @Override
    public Class<AuditFeeSettlementCheckDetailPlanVo> getVoClass() {
        return AuditFeeSettlementCheckDetailPlanVo.class;
    }

    @Override
    public List<AuditFeeSettlementCheckDetailPlanDto> findDtoListFromRepository(AuditFeeSettlementCheckDetailPlanDto dto, String cacheKey) {
        log.info("缓存查询细案信息：{}", JSONObject.toJSONString(dto));
        if (Objects.isNull(dto) || StringUtils.isEmpty(dto.getCode())) {
            return Lists.newArrayList();
        }
        return this.detailPlanRepository.findDtoByCode(dto.getCode());
    }

    @Override
    public List<AuditFeeSettlementCheckDetailPlanDto> newItem(String cacheKey, List<AuditFeeSettlementCheckDetailPlanDto> itemList) {
        return itemList;
    }

    @Override
    public List<AuditFeeSettlementCheckDetailPlanDto> copyItem(String cacheKey, List<AuditFeeSettlementCheckDetailPlanDto> itemList) {
        return itemList;
    }

    @Override
    public Object getDtoKey(AuditFeeSettlementCheckDetailPlanDto dto) {
        return dto.getDetailPlanItemCode();
    }

    @Override
    public String getCheckedStatus(AuditFeeSettlementCheckDetailPlanDto dto) {
        return dto.getChecked();
    }

    @Override
    public void filterSaveItem(String cacheKey, List<Object> idList, List<AuditFeeSettlementCheckDetailPlanDto> itemList, List<AuditFeeSettlementCheckDetailPlanDto> updateList) {
        if (CollectionUtils.isEmpty(idList) || CollectionUtils.isEmpty(itemList)) return;
        // remove repeat item in itemList
        itemList.removeIf(e -> idList.contains(this.getDtoKey(e)));
    }


    /**
     * 放入缓存的key数据重排序
     * @param cacheKey
     * @param newIdArr
     */
    public void doSaveNewKey(String cacheKey,Object[] newIdArr){
        if (newIdArr.length == 0){
            return;
        }
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        List<String> idStrList = new ArrayList<>();
        List<Object> idList = redisService.lRange(redisCacheIdKey, 0, -1);
        for (Object id : idList) {
            redisService.lRemove(redisCacheIdKey, 0, id);
            idStrList.add((String) id);
        }
        for (Object o : newIdArr) {
            idStrList.add((String) o);
        }
        // 字符串正序
        log.info("活动排序前:{}", Arrays.toString(idStrList.toArray()));
        Collections.sort(idStrList);
        log.info("活动排序后:{}", Arrays.toString(idStrList.toArray()));

        redisService.lPushAll(redisCacheIdKey, this.getExpireTime(), idStrList.toArray());
    }
}
