package com.biz.crm.tpm.business.audit.fee.local.helper;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.kms.business.audit.fee.sdk.service.cost.AuditFeeCostService;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDiffRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeSettlementConstant;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDiffDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDiffVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @Description
 * @Author zhouYang
 * @Date 2023/09/28
 */
@Slf4j
@Component
public class AuditFeeSettlementCheckDiffHelper extends MnPageCacheHelper<AuditFeeSettlementCheckDiffVo, AuditFeeSettlementCheckDiffDto> {

    @Autowired(required = false)
    private AuditFeeCostService auditFeeCostService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private AuditFeeSettlementCheckDiffRepository repository;

    @Override
    public String getCacheKeyPrefix() {
        return AuditFeeSettlementConstant.CACHE_PREFIX_DIFF;
    }

    @Override
    public Class<AuditFeeSettlementCheckDiffDto> getDtoClass() {
        return AuditFeeSettlementCheckDiffDto.class;
    }

    @Override
    public Class<AuditFeeSettlementCheckDiffVo> getVoClass() {
        return AuditFeeSettlementCheckDiffVo.class;
    }

    @Override
    public List<AuditFeeSettlementCheckDiffDto> findDtoListFromRepository(AuditFeeSettlementCheckDiffDto dto, String cacheKey) {
        log.info("缓存查询差异信息：{}", JSONObject.toJSONString(dto));
        if (Objects.isNull(dto) || StringUtils.isEmpty(dto.getCode())) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckDiffVo> list = repository.findAllByCode(dto.getCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeeSettlementCheckDiffDto>) this.nebulaToolkitService.copyCollectionByWhiteList(list,AuditFeeSettlementCheckDiffVo.class,AuditFeeSettlementCheckDiffDto.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<AuditFeeSettlementCheckDiffDto> newItem(String cacheKey, List<AuditFeeSettlementCheckDiffDto> itemList) {
        return itemList;
    }

    @Override
    public List<AuditFeeSettlementCheckDiffDto> copyItem(String cacheKey, List<AuditFeeSettlementCheckDiffDto> itemList) {
        return itemList;
    }

    @Override
    public Object getDtoKey(AuditFeeSettlementCheckDiffDto dto) {
        return dto.getFeeDiffLedgerCode();
    }

    @Override
    public String getCheckedStatus(AuditFeeSettlementCheckDiffDto dto) {
        return dto.getChecked();
    }

    @Override
    public void filterSaveItem(String cacheKey, List<Object> idList, List<AuditFeeSettlementCheckDiffDto> itemList, List<AuditFeeSettlementCheckDiffDto> updateList) {
        if (CollectionUtils.isEmpty(idList) || CollectionUtils.isEmpty(itemList)) return;
        // remove repeat item in itemList
        itemList.removeIf(e -> idList.contains(this.getDtoKey(e)));
    }
}
