package com.biz.crm.tpm.business.audit.fee.local.helper;

import com.biz.crm.kms.business.audit.fee.sdk.vo.AuditFeeRespVo;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckFee;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckFeeRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeSettlementConstant;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @Description
 * @Author zhouYang
 * @Date 2023/09/28
 */
@Slf4j
@Component
public class AuditFeeSettlementCheckFeeHelper extends MnPageCacheHelper<AuditFeeSettlementCheckFeeVo, AuditFeeSettlementCheckFeeDto> {

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private AuditFeeSettlementCheckFeeRepository feeRepository;

    @Override
    public String getCacheKeyPrefix() {
        return AuditFeeSettlementConstant.CACHE_PREFIX_FEE;
    }

    @Override
    public Class<AuditFeeSettlementCheckFeeDto> getDtoClass() {
        return AuditFeeSettlementCheckFeeDto.class;
    }

    @Override
    public Class<AuditFeeSettlementCheckFeeVo> getVoClass() {
        return AuditFeeSettlementCheckFeeVo.class;
    }

    @Override
    public List<AuditFeeSettlementCheckFeeDto> findDtoListFromRepository(AuditFeeSettlementCheckFeeDto dto, String cacheKey) {
        if (Objects.isNull(dto) || StringUtils.isEmpty(dto.getCode())) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckFee> list = this.feeRepository.findByCode(dto.getCode());
        if (!CollectionUtils.isEmpty(list)) {
            return (List<AuditFeeSettlementCheckFeeDto>) nebulaToolkitService.copyCollectionByWhiteList(list,AuditFeeSettlementCheckFee.class,AuditFeeSettlementCheckFeeDto.class, HashSet.class,ArrayList.class);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<AuditFeeSettlementCheckFeeDto> newItem(String cacheKey, List<AuditFeeSettlementCheckFeeDto> itemList) {
        return itemList;
    }

    @Override
    public List<AuditFeeSettlementCheckFeeDto> copyItem(String cacheKey, List<AuditFeeSettlementCheckFeeDto> itemList) {
        return itemList;
    }

    @Override
    public Object getDtoKey(AuditFeeSettlementCheckFeeDto dto) {
        return dto.getId();
    }

    @Override
    public String getCheckedStatus(AuditFeeSettlementCheckFeeDto dto) {
        return dto.getChecked();
    }

    @Override
    public void filterSaveItem(String cacheKey, List<Object> idList, List<AuditFeeSettlementCheckFeeDto> itemList, List<AuditFeeSettlementCheckFeeDto> updateList) {
        if (CollectionUtils.isEmpty(idList) || CollectionUtils.isEmpty(itemList)) return;
        // remove repeat item in itemList
        itemList.removeIf(e -> idList.contains(this.getDtoKey(e)));
        for (AuditFeeSettlementCheckFeeDto dto : itemList) {
            //  从KMS选择的数据，在这里转换
            if (dto.getTpmDeductionCode() != null) {
                dto.setFeeDetailCode(dto.getTpmDeductionCode());
            }
        }
    }
}
