package com.biz.crm.tpm.business.audit.fee.local.helper;

import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeSettlementConstant;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description
 * @Author zhouYang
 * @Date 2023/09/28
 */
@Slf4j
@Component
public class AuditFeeSettlementCheckHelper extends MnPageCacheHelper<AuditFeeSettlementCheckVo, AuditFeeSettlementCheckDto> {

    @Override
    public String getCacheKeyPrefix() {
        return AuditFeeSettlementConstant.CACHE_PREFIX;
    }

    @Override
    public Class<AuditFeeSettlementCheckDto> getDtoClass() {
        return AuditFeeSettlementCheckDto.class;
    }

    @Override
    public Class<AuditFeeSettlementCheckVo> getVoClass() {
        return AuditFeeSettlementCheckVo.class;
    }

    @Override
    public List<AuditFeeSettlementCheckDto> findDtoListFromRepository(AuditFeeSettlementCheckDto dto, String cacheKey) {
        return Lists.newArrayList();
    }

    @Override
    public List<AuditFeeSettlementCheckDto> newItem(String cacheKey, List<AuditFeeSettlementCheckDto> itemList) {
        return itemList;
    }

    @Override
    public List<AuditFeeSettlementCheckDto> copyItem(String cacheKey, List<AuditFeeSettlementCheckDto> itemList) {
        return itemList;
    }

    @Override
    public Object getDtoKey(AuditFeeSettlementCheckDto dto) {
        return dto.getId();
    }

    @Override
    public String getCheckedStatus(AuditFeeSettlementCheckDto dto) {
        return dto.getChecked();
    }
}
