package com.biz.crm.tpm.business.audit.fee.local.helper;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeReqDto;
import com.biz.crm.kms.business.audit.fee.sdk.service.statement.AuditFeeStatementService;
import com.biz.crm.kms.business.audit.fee.sdk.vo.AuditFeeRespVo;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckSettlementRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeSettlementConstant;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @Description
 * @Author zhouYang
 * @Date 2023/09/28
 */
@Slf4j
@Component
public class AuditFeeSettlementCheckSettlementHelper extends MnPageCacheHelper<AuditFeeSettlementCheckSettlementVo, AuditFeeSettlementCheckSettlementDto> {

    @Autowired
    private AuditFeeSettlementCheckSettlementRepository settlementRepository;
    @Autowired
    private AuditFeeStatementService auditFeeStatementService;

    @Override
    public String getCacheKeyPrefix() {
        return AuditFeeSettlementConstant.CACHE_PREFIX_SETTLEMENT;
    }

    @Override
    public Class<AuditFeeSettlementCheckSettlementDto> getDtoClass() {
        return AuditFeeSettlementCheckSettlementDto.class;
    }

    @Override
    public Class<AuditFeeSettlementCheckSettlementVo> getVoClass() {
        return AuditFeeSettlementCheckSettlementVo.class;
    }

    @Override
    public List<AuditFeeSettlementCheckSettlementDto> findDtoListFromRepository(AuditFeeSettlementCheckSettlementDto dto, String cacheKey) {
        log.info("缓存，数据库查询写入缓存入参：{}", JSONObject.toJSONString(dto));
        if (Objects.isNull(dto) || StringUtils.isEmpty(dto.getCode())) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckSettlementDto> list = this.settlementRepository.findAllByCode(dto.getCode());
//        if (!CollectionUtils.isEmpty(list)) {
//            list.forEach(e ->{
//                // 分页
//                Pageable pageable = Pageable.ofSize(1);
//                // 查询参数
//                AuditFeeReqDto kmsDto = new AuditFeeReqDto();
//                kmsDto.setTpmDeductionCode(e.getDeductionCode());
//                kmsDto.setDataSource(e.getDataSource());
//                Page<AuditFeeRespVo> kmsSettlementVoPage = this.auditFeeStatementService.findByConditions(pageable,kmsDto);
//                Optional<Long> total = Optional.ofNullable(kmsSettlementVoPage).map(Page::getTotal);
//                if (total.isPresent()) {
//                    log.info("==============结算单总条数:{}",total.get());
//                    AuditFeeRespVo kmsSettlement = kmsSettlementVoPage.getRecords().get(0);
//                    this.kmsToTpm(e,kmsSettlement);
//                }
//            });
//        }
        return list;
    }

    private void kmsToTpm(AuditFeeSettlementCheckSettlementDto e, AuditFeeRespVo kmsSettlement) {
        //e.setSettlementDetailCode();
        e.setBusinessArea(kmsSettlement.getBusinessArea());
        e.setDirectCode(kmsSettlement.getCustomerRetailerCode());
        e.setSupermarketName(kmsSettlement.getCustomerRetailerName());
        e.setProvinceCode(kmsSettlement.getProvinceCode());
        e.setProvinceName(kmsSettlement.getProvinceName());
        e.setDeliveryPartyCode(kmsSettlement.getDeliveryPartyCode());
        e.setDeliveryPartyName(kmsSettlement.getDeliveryPartyName());
        e.setProductCode(kmsSettlement.getProductCode());
        e.setProductName(kmsSettlement.getProductName());
        e.setSlotDateName(kmsSettlement.getSlotDateName());
        e.setOrderDate(kmsSettlement.getOrderDate());
        e.setOrderYearMonth(kmsSettlement.getOrderYearMonth());
        e.setDeductionName(kmsSettlement.getDeductionName());
        e.setAuditWay(kmsSettlement.getAuditWay());
        e.setAmount(kmsSettlement.getAmount());
    }

    @Override
    public List<AuditFeeSettlementCheckSettlementDto> newItem(String cacheKey, List<AuditFeeSettlementCheckSettlementDto> itemList) {
        return itemList;
    }

    @Override
    public List<AuditFeeSettlementCheckSettlementDto> copyItem(String cacheKey, List<AuditFeeSettlementCheckSettlementDto> itemList) {
        return itemList;
    }

    @Override
    public Object getDtoKey(AuditFeeSettlementCheckSettlementDto dto) {
        return dto.getId();
    }

    @Override
    public String getCheckedStatus(AuditFeeSettlementCheckSettlementDto dto) {
        return dto.getChecked();
    }

    @Override
    public void filterSaveItem(String cacheKey, List<Object> idList, List<AuditFeeSettlementCheckSettlementDto> itemList, List<AuditFeeSettlementCheckSettlementDto> updateList) {
        if (CollectionUtils.isEmpty(idList) || CollectionUtils.isEmpty(itemList)) return;
        // remove repeat item in itemList
        itemList.removeIf(e -> idList.contains(this.getDtoKey(e)));
        for (AuditFeeSettlementCheckSettlementDto dto : itemList) {
            //  从KMS选择的数据，在这里转换
            if (dto.getTpmDeductionCode() != null) {
                dto.setSettlementDetailCode(dto.getTpmDeductionCode());
            }
        }
    }
}
