package com.biz.crm.tpm.business.audit.fee.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import com.biz.crm.tpm.business.third.system.sdk.constants.FeePoolConstant;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Date;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author liyang
 * @date 2023/11/07
 */
@Service
@Slf4j
public class AuditFeeCheckJob {

  @Autowired
  private AuditFeeCheckVoService auditFeeCheckVoService;
  @Autowired
  private LoginUserService loginUserService;

  @DynamicTaskService(cornExpression = "0 0 1 * * ?", taskDesc = "费用核对管理自动同步数据")
  public void pullKmsDataTask() {
    loginUserService.refreshAuthentication(null);
    log.info("----> {}费用核对管理自动同步数据开始 <----", DateUtil.format(new Date(), FeePoolConstant.DATE_FORMAT));
    auditFeeCheckVoService.pullKmsDataAndMatchTask();
    log.info("----> {}费用核对管理自动同步数据结束 <----", DateUtil.format(new Date(), FeePoolConstant.DATE_FORMAT));
  }
}
