package com.biz.crm.tpm.business.audit.fee.local.job;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosPullKmsDataService;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.AuditFeeCheckPosMatchActivityServiceImpl;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeCheckPosConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/7/5
 */
@Slf4j
@Service
public class AuditFeeCheckPosJob {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private AuditFeeCheckPosVoService auditFeeCheckPosVoService;

    @Autowired(required = false)
    private AuditFeeCheckPosPullKmsDataService auditFeeCheckPosPullKmsDataService;

    @Autowired(required = false)
    private AuditFeeCheckPosMatchActivityServiceImpl auditFeeCheckPosMatchActivityServiceImpl;

    @DynamicTaskService(cornExpression = "0 10 0 * * ?", taskDesc = "每日0:10 执行一次更新POS活动核对的KMS数据")
    public void updateKmsDataJob() {
        /**
         * 15号及之前更新上月和本月POS，15号后只更新本月数据
         */
        loginUserService.refreshAuthentication(null);
        String yearMonthDay = DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String lockKey = AuditFeeConstants.AUDIT_FEE_UPDATE_KMS_POS_LOCK + yearMonthDay;
        boolean lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4);
        Assert.isTrue(lockSuccess, "上次操作[" + yearMonthDay + "]还未完成,本次不执行!");
        try {
            auditFeeCheckPosPullKmsDataService.pullKmsData(null, null);
        } catch (Exception e) {
            log.error("拉取KMS的POS数据时异常");
            log.error("", e);
        } finally {
            this.redisLockService.unlock(lockKey);
        }
    }

    @DynamicTaskService(cornExpression = "0 0 6 * * ?", taskDesc = "每日06:00 执行一次TPM-POS匹配活动")
    public void posMatchActivityJob() {
        loginUserService.refreshAuthentication(null);
        Date dateNow = new Date();
        String yearMonthDay = DateUtil.format(dateNow, DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String lockKey = AuditFeeConstants.AUDIT_FEE_UPDATE_KMS_POS_LOCK + yearMonthDay;
        boolean lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4);
        Assert.isTrue(lockSuccess, "上次操作[" + yearMonthDay + "]还未完成,本次不执行!");
        Pageable pageable = PageRequest.of(1, 600);
        AuditFeeCheckPosDto selectDto = new AuditFeeCheckPosDto();
        selectDto.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
        selectDto.setModifyTimeBegin(DateUtil.formatDate(DateUtil.dateAddDay(new Date(),
                AuditFeeCheckPosConstants.AUDIT_FEE_KMS_POS_DAY), DateUtil.DEFAULT_YEAR_MONTH_DAY));
        selectDto.setTenantCode(TenantUtils.getTenantCode());
        try {
            Page<AuditFeeCheckPosVo> page = null;
            do {
                try {
                    page = auditFeeCheckPosVoService.findByConditions(pageable, selectDto);
                    log.info("POS匹配活动定时任务 start [{}/{}]", page.getCurrent(), page.getPages());
                    auditFeeCheckPosMatchActivityServiceImpl.posMatchActivity(null, page.getRecords());
                    pageable = pageable.next();
                } catch (Exception e) {
                    if (Objects.isNull(page)) {
                        page = new Page<>();
                    }
                    log.info("POS匹配活动定时任务异常,当前处理页:[{}/{}]", page.getCurrent(), page.getPages());
                    log.error("", e);
                }
                log.info("POS匹配活动定时任务 end [{}/{}]", page.getCurrent(), page.getPages());
            } while (page.hasNext());
        } catch (Exception e) {
            log.error("POS匹配活动定时任务执行失败{}", e.getMessage());
            log.error("", e);
        } finally {
            this.redisLockService.unlock(lockKey);
        }
    }

}
