package com.biz.crm.tpm.business.audit.fee.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.third.system.sdk.constants.FeePoolConstant;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;

@Slf4j
@Service
public class AuditFeePredictionAutoSyncXxlJob {

    @Autowired
    private AuditFeePredictionService auditFeePredictionService;
    @Autowired
    private LoginUserService loginUserService;

    @DynamicTaskService(cornExpression = "0 0 1 * * ?", taskDesc = "扣费预测管理自动更新数据")
    public void autoJobUpdate() {
        loginUserService.refreshAuthentication(null);
        log.info("----> {} 扣费预测管理自动更新数据执行定时任务 <----", DateUtil.format(new Date(), FeePoolConstant.DATE_FORMAT));
        auditFeePredictionService.autoJobUpdate();
        log.info("----> {} 扣费预测管理自动更新数据定时任务执行完毕 <----", DateUtil.format(new Date(), FeePoolConstant.DATE_FORMAT));
    }

    @DynamicTaskService(cornExpression = "0 0 2 * * ?", taskDesc = "扣费预测管理自动同步未同步数据")
    public void autoJobSync() {
        loginUserService.refreshAuthentication(null);
        log.info("----> {} 扣费预测管理自动同步未同步数据执行定时任务 <----", DateUtil.format(new Date(), FeePoolConstant.DATE_FORMAT));
        auditFeePredictionService.autoJobSync(new AuditFeePredictionDto());
        log.info("----> {} 扣费预测管理自动同步未同步数据定时任务执行完毕 <----", DateUtil.format(new Date(), FeePoolConstant.DATE_FORMAT));
    }
}
