package com.biz.crm.tpm.business.audit.fee.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckService;
import com.biz.crm.tpm.business.third.system.sdk.constants.FeePoolConstant;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Slf4j
@Service
public class AuditFeeSettlementCheckAutoSyncXxlJob {

    @Autowired
    private AuditFeeSettlementCheckService auditFeeSettlementCheckService;
    @Autowired
    private LoginUserService loginUserService;

    @DynamicTaskService(cornExpression = "0 15 1 * * ?", taskDesc = "结算核对管理自动同步数据")
    public void pullFeePoolData() {
        loginUserService.refreshAuthentication(null);
        log.info("----> {}结算核对管理自动同步数据 <----", DateUtil.format(new Date(), FeePoolConstant.DATE_FORMAT));
        auditFeeSettlementCheckService.autoJobUpdate();
        log.info("----> {} 结算核对管理自动同步数据 <----", DateUtil.format(new Date(), FeePoolConstant.DATE_FORMAT));
    }
}
