package com.biz.crm.tpm.business.audit.fee.local.listener;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.IsPushEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeVerifyDecideService;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.event.AuditFeeVerifyDecideEventListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Objects;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Slf4j
@Component
public class AuditFeeVerifyDecideEventListenerImpl implements AuditFeeVerifyDecideEventListener {

    @Autowired(required = false)
    private AuditFeeVerifyDecideService auditFeeVerifyDecideService;

    @Override
    public void onDelete(AutoAuditDto dto) {
        if (Objects.isNull(dto)){
            return;
        }
        log.info("核销删除触发扣费核定管理事件，dto:{}", JSONObject.toJSONString(dto));
        if (CollectionUtils.isEmpty(dto.getAuditCodeList()) && CollectionUtils.isEmpty(dto.getAuditDetailCodeList())) {
            return;
        }
        this.auditFeeVerifyDecideService.updateStatusByAudit(dto.getAuditCodeList(),dto.getAuditDetailCodeList());
    }
}
