package com.biz.crm.tpm.business.audit.fee.local.mapper.check;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckCostDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 核销费用核对关联费用单表(数据源至KMS)(AuditFeeCheckCost)表数据库访问层
 *
 * @author makejava
 * @date 2022-11-14 17:32:57
 */
public interface AuditFeeCheckCostMapper extends BaseMapper<AuditFeeCheckCost> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<AuditFeeCheckCostVo> findByConditions(Page<AuditFeeCheckCostVo> page, @Param("dto") AuditFeeCheckCostDto dto);

    /**
     * 分页获取未匹配费用单
     *
     * @param dto
     * @param pageNumber
     * @param pageSize
     * @return
     */
    List<AuditFeeCheckCostVo> findUnmatedCost(@Param("dto")AuditFeeCheckCostDto dto,@Param("pageNumber") int pageNumber, @Param("pageSize") int pageSize);

    /**
     * 获取未匹配费用单总条数
     *
     * @param dto
     * @return
     */
    Integer getUnmatementCostTotal(@Param("dto")AuditFeeCheckCostDto dto);

    AuditFeeCheckCost findSumAmountByMd5UniqueKey(@Param("md5UniqueKey") String md5UniqueKey, @Param("tenantCode") String tenantCode);

    void deleteUsedCosts(@Param("md5UniqueKeyList") List<String> md5UniqueKeyList);
}

