package com.biz.crm.tpm.business.audit.fee.local.mapper.check;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 核销费用核对关联细案表(AuditFeeCheckDetailPlan)表数据库访问层
 *
 * @author makejava
 * @date 2022-12-06 14:19:00
 */
public interface AuditFeeCheckDetailPlanMapper extends BaseMapper<AuditFeeCheckDetailPlan> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<AuditFeeCheckDetailPlanVo> findByConditions(
            Page<AuditFeeCheckDetailPlanVo> page, @Param("dto") AuditFeeCheckDetailPlanDto dto);

    /**
     * 分页扣费核定列表
     * @param page 分页信息
     * @param dto 分页参数dto
     * @return 分页列表
     */
    List<AuditFeeVerifyDecideVo> findForFeeVerifyDecideByConditions(@Param("dto") AuditFeeVerifyDecideDto dto);

    /**
     * 扣费核定列表（新）
     * @param dto
     * @return
     */
    Page<AuditFeeVerifyDecideVo> findAuditFeeVerifyDecideByConditionsNew(Page page,@Param("dto") AuditFeeVerifyDecideDto dto);

    /**
     * 扣费核定列表（新）
     * @param dto
     * @return
     */
    List<AuditFeeVerifyDecideVo> findAuditFeeVerifyDecideByConditionsNew(@Param("dto") AuditFeeVerifyDecideDto dto);

    /**
     * 获取扣费核定导出总数
     * @param dto
     * @return
     */
    Integer findAuditFeeVerifyDecideExportTotal(@Param("dto") AuditFeeVerifyDecideDto dto);

    /**
     * 查询已匹配且费用核对未确认的活动编码
     * @param detailPlanItemCodes
     * @return
     */
    List<String> findNoConfirmByDetailPlanItemCodeList(@Param("detailPlanItemCodes") List<String> detailPlanItemCodes,@Param("tenantCode") String tenantCode);

    void updateMatchCodeByMatchCostAndPos(@Param("matchCode") String matchCode, @Param("posIds") List<String> posIds, @Param("tenantCode") String tenantCode);

    List<AuditFeeCheckDetailPlanVo> findActivityDetailPlanBySupermarketCostCodes(@Param("list") List<String> supermarketCostCodes);

    List<AuditFeeCheckDetailPlanVo> findDetailPlanByMatchCode(@Param("matchCode") String matchCode, @Param("tenantCode") String tenantCode);

    List<AuditFeeCheckDetailPlanVo> findActivityAndShareByActivityItemCodes(@Param("codes") List<String> activityItemCodes,@Param("tenantCode") String tenantCode);

}

