package com.biz.crm.tpm.business.audit.fee.local.mapper.check;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheck;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditCheckDetailExportsDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditCheckDetailExportsVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 核销费用核对主表(AuditFeeCheck)表数据库访问层
 *
 * @author makejava
 * @date 2022-11-14 16:55:58
 */
public interface AuditFeeCheckMapper extends BaseMapper<AuditFeeCheck> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<AuditFeeCheckVo> findByConditions(
            Page<AuditFeeCheckVo> page, @Param("dto") AuditFeeCheckDto dto);



    /**
     * 费用核对明细导出获取总数
     * @param dto
     * @return
     */
    Integer getTotal(@Param("dto") AuditCheckDetailExportsDto dto, @Param("sourceType") String sourceType);

    /**
     * 费用核对明细导出获取数据
     * @param dto
     * @return
     */
    List<AuditCheckDetailExportsVo> findData(@Param("dto") AuditCheckDetailExportsDto dto, @Param("sourceType") String sourceType);


    List<TpmDeductionDetailMappingVo> findMappingCodeByMatchCodes(@Param("matchCodes") List<String> matchCodes);

    String findMappingCode(@Param("code") String matchCode);

    Page<AuditFeeCheckVo> findByConditionsForEct(Page<AuditFeeCheckVo> page, @Param("dto") AuditFeeCheckSelectDto dto);

    void updateSummaryCondition(@Param("AuditFeeCheckList") List<AuditFeeCheckVo> list);

    Page<String> findNotConfirmedDiffPage(Page<String> page, @Param("dto") AuditFeeCheckDto dto);
}

