package com.biz.crm.tpm.business.audit.fee.local.mapper.check;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:核销费用核对POS表数据库访问层
 * @Author qiancheng
 * @Date 2023/5/29
 */
public interface AuditFeeCheckPosMapper extends BaseMapper<AuditFeeCheckPos> {

    /**
     * 分页查询费用核对Pos数据
     *
     * @param page 分页对象
     * @param dto  实体对象
     * @return 分页数据
     */
    Page<AuditFeeCheckPosVo> findByConditions(@Param("page") Page<AuditFeeCheckPosVo> page, @Param("dto") AuditFeeCheckPosDto dto);

    /**
     * 更新数据
     *
     * @param entity
     */
    void updateAmountById(@Param("dto") AuditFeeCheckPos entity);

    /**
     * 计算差异总金额
     *
     * @param idList
     */
    void computeTotalDiffAmount(@Param("idList") List<String> idList);
}
