package com.biz.crm.tpm.business.audit.fee.local.mapper.check;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckStatement;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckStatementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckStatementVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 核销费用核对关联结算单单表(数据源至KMS)(AuditFeeCheckStatement)表数据库访问层
 *
 * @author makejava
 * @date 2022-12-06 14:20:22
 */
public interface AuditFeeCheckStatementMapper extends BaseMapper<AuditFeeCheckStatement> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<AuditFeeCheckStatementVo> findByConditions(
            Page<AuditFeeCheckStatementVo> page, @Param("dto") AuditFeeCheckStatementDto dto);

    /**
     *获取未匹配结算单总条数
     *
     * @param dto
     * @return
     */
    Integer getUnmatchedStatementTotal(@Param("dto")AuditFeeCheckStatementDto dto);

    /**
     * 分页获取未匹配结算单
     *
     * @param dto
     * @param pageNumber
     * @param pageSize
     * @return
     */
    List<AuditFeeCheckStatementVo> findUnmatchedStatement(@Param("dto")AuditFeeCheckStatementDto dto,@Param("pageNumber") int pageNumber,@Param("pageSize") int pageSize);
}

