package com.biz.crm.tpm.business.audit.fee.local.mapper.dispose;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 核销差异费用处理明细(AuditFeeDiffDisposeDetail)表数据库访问层
 *
 * @author liuyifan
 * @date 2022-12-24 13:56:10
 */
public interface AuditFeeDiffDisposeDetailMapper extends BaseMapper<AuditFeeDiffDisposeDetail> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<AuditFeeDiffDisposeDetailVo> findByConditions(
            Page<AuditFeeDiffDisposeDetailVo> page, @Param("dto") AuditFeeDiffDisposeDetailDto dto);

    /**
     * 查询明细
     * @param dto
     * @return {@link List}<{@link AuditFeeDiffDisposeDetailVo}>
     */
    List<AuditFeeDiffDisposeDetailVo> findByFeeDiffDisposeCode(@Param("dto") AuditFeeDiffDisposeDetailDto dto);
}

