package com.biz.crm.tpm.business.audit.fee.local.mapper.ledger;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedger;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import org.apache.ibatis.annotations.Param;

/**
 * 核销差异费用台账(AuditFeeDiffLedger)表数据库访问层
 *
 * @author makejava
 * @date 2022-12-19 11:02:12
 */
public interface AuditFeeDiffLedgerMapper extends BaseMapper<AuditFeeDiffLedger> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<AuditFeeDiffLedgerVo> findByConditions(Page<AuditFeeDiffLedgerVo> page, @Param("dto") AuditFeeDiffLedgerDto dto);

    /**
     * 选择台帐列表
     * @param page
     * @param dto
     * @return {@link Page}<{@link AuditFeeDiffLedgerVo}>
     */
    Page<AuditFeeDiffLedgerVo> selectByConditions(Page<AuditFeeDiffLedgerVo> page, @Param("dto") AuditFeeDiffLedgerDto dto);
}

