package com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 结算核对表数据库访问层
 *
 * @author zy
 * @date 2023-09-25
 */
public interface AuditFeeSettlementCheckDetailPlanMapper extends BaseMapper<AuditFeeSettlementCheckDetailPlan> {

    Page<AuditFeeSettlementCheckDetailPlanVo> findByConditions(Page<AuditFeeSettlementCheckDetailPlanVo> page, @Param("dto") AuditFeeSettlementCheckDetailPlanDto dto);

    List<AuditFeeSettlementCheckDetailPlanVo> findWithShare(@Param("ids") List<String> ids, @Param("tenantCode") String tenantCode);

    List<AuditFeeSettlementCheckDetailPlanVo> findWithShareByCodes(@Param("codes") List<String> codes, @Param("tenantCode") String tenantCode);

    List<AuditFeeSettlementCheckDetailPlanVo> findActivityAndShareByActivityItemCodes(@Param("codes") List<String> activityItemCodes,@Param("tenantCode") String tenantCode);

    /**
     * 查询已匹配且未确认的活动编码
     * @param detailPlanItemCodes
     * @return
     */
    List<String> findNoConfirmByDetailPlanItemCodeList(@Param("detailPlanItemCodes") List<String> detailPlanItemCodes, @Param("tenantCode") String tenantCode);
}

