package com.biz.crm.tpm.business.audit.fee.local.mapper.track;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetail;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 核销费用核对主表(AuditFeeCheck)表数据库访问层
 *
 * @author makejava
 * @date 2022-11-14 16:55:58
 */
public interface AuditFeeDiffTrackDetailMapper extends BaseMapper<AuditFeeDiffTrackDetail> {

    Page<AuditFeeDiffTrackDetailVo> findByConditions(Page<AuditFeeDiffTrackDetailVo> page, @Param("dto") AuditFeeDiffTrackDetailDto dto);

    List<AuditFeeDiffTrackDetailVo> findByPlanCodeList(@Param("planCodeList") List<String> planCodeList);

    List<AuditFeeDiffTrackDetailVo> findByTemplateConfigCodeList(@Param("templateConfigCodeList") List<String> templateConfigCodeList);

    Page<AuditFeeDiffTrackDetailVo> auditFindByConditions(@Param("page") Page<AuditFeeDiffTrackDetailVo> page, @Param("dto") AuditFeeDiffTrackDetailDto dto);

    void updateAlreadyAuditAmountByValidationPass(@Param("dtoList") List<AuditFeeDiffTrackDetailDto> dtoList, @Param("tenantCode") String tenantCode);
    List<AuditFeeDiffTrackDetailVo> findByDetailCodes(@Param("detailCodes") List<String> detailCodes, @Param("tenantCode") String tenantCode);

    List<String> findEndCastFormByDetailCodes(@Param("codes") List<String> detailCodes,@Param("tenantCode") String tenantCode);

    List<AuditFeeDiffTrackDetailVo> findNeedBePushCowManagerButNot(@Param("tenantCode") String tenantCode);
}

