package com.biz.crm.tpm.business.audit.fee.local.notifier;

import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeDiffDisposeService;
import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 事件侦听器
 *
 * @author liuyifan
 * @date 2022/12/27
 */
@Component
public class AuditFeeDiffDisposeEventListenerImpl implements AuditFeeDiffDisposeEventListener {
    @Autowired
    private AuditFeeDiffDisposeRepository auditFeeDiffDisposeRepository;

    @Autowired
    private AuditFeeDiffDisposeService auditFeeDiffDisposeService;

    @Override
    public void onCreate(AuditFeeDiffDisposeVo vo) {

    }

    @Override
    public void onUpdate(AuditFeeDiffDisposeVo oldVo, AuditFeeDiffDisposeVo newVo) {

    }

    @Override
    public void onEnable(List<AuditFeeDiffDisposeVo> list) {

    }

    @Override
    public void onDisable(List<AuditFeeDiffDisposeVo> list) {

    }

    @Override
    public void onDelete(List<AuditFeeDiffDisposeVo> list) {

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onUpdateProcessStatus(String processStatus, String processNo) {
        if(!StringUtils.hasText(processStatus)){
            return;
        }
        //修改审批状态
        auditFeeDiffDisposeRepository.updateProcessStatus(processStatus,processNo);
        ProcessStatusEnum processStatusEnum = ProcessStatusEnum.getStatusEnumByDictCode(processStatus);
        switch (processStatusEnum){
            case PASS:
                //审批通过
                break;
            case REJECT:
                //审批驳回
                break;
            default:
                break;
        }
    }
}
