package com.biz.crm.tpm.business.audit.fee.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.log.AuditFeeDiffLedgerLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.ledger.log.AuditFeeDiffLedgerLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeDiffLedgerLogEventListenerImpl  implements AuditFeeDiffLedgerLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 新增时日志记录
     * @param dto 细案预测单新旧vo对象
     */
    @Override
    public void onCreate(AuditFeeDiffLedgerLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    /**
     * 删除时日志记录
     * @param dto 细案预测单新旧vo对象
     */
    @Override
    public void onDelete(AuditFeeDiffLedgerLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    /**
     * 修改时日志记录
     * @param dto 细案预测单新旧vo对象
     */
    @Override
    public void onUpdate(AuditFeeDiffLedgerLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    @Override
    public void onEnable(AuditFeeDiffLedgerLogEventDto eventDto) {

    }

    @Override
    public void onDisable(AuditFeeDiffLedgerLogEventDto eventDto) {

    }


    /**
     * 构建日志dto对象
     * @param crmBusinessLogDto 日志dto
     * @param eventDto 新旧vo对象
     */
    private void buildCrmBusinessLog(CrmBusinessLogDto crmBusinessLogDto, AuditFeeDiffLedgerLogEventDto eventDto) {
        crmBusinessLogDto.setOnlyKey(eventDto.getNewest().getId());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(eventDto.getOriginal());
        crmBusinessLogDto.setNewObject(eventDto.getNewest());
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
