package com.biz.crm.tpm.business.audit.fee.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对(AuditFee)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-11 10:31:00
 */
@Component
public class AuditFeeDiffDisposeDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_audit_fee_diff_dispose_data_view";
    }

    @Override
    public String desc() {
        return "TPM-核销差异费用处理";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_audit_fee_diff_dispose t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";

    }

}
