package com.biz.crm.tpm.business.audit.fee.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @Description:商超费用pos数据视图
 * @Author qiancheng
 * @Date 2023/6/1
 */
@Component
public class AuditFeePosDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_audit_fee_check_pos_data_view";
    }

    @Override
    public String desc() {
        return "TPM-核销费用核对POS数据";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_audit_fee_check_pos t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
