package com.biz.crm.tpm.business.audit.fee.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 商超费用pos汇总数据视图
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-11-06 22:32
 */
@Component
public class AuditFeePosHeadDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_audit_fee_check_pos_head_data_view";
    }

    @Override
    public String desc() {
        return "TPM-核销费用核对POS汇总数据";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_audit_fee_check_pos_head t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
