package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckCostMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckCostDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对关联费用单表(数据源至KMS)(repository)
 *
 * @author makejava
 * @date 2022-11-14 17:32:57
 */
@Component
public class AuditFeeCheckCostRepository extends ServiceImpl<AuditFeeCheckCostMapper, AuditFeeCheckCost> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeCheckCostVo> findByConditions(Page<AuditFeeCheckCostVo> page, AuditFeeCheckCostDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeCheckCost findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeCheckCost> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeCheckCost::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeCheckCost::getId, ids)
                .set(AuditFeeCheckCost::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeCheckCost::getId, ids)
                .set(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    /**
     * 根据费用核对编码查询费用单列表
     * @param matchCode 费用核对编码
     * @return 费用单列表
     */
    public List<AuditFeeCheckCost> findDetailByMatchCode(String matchCode) {
        if (StringUtils.isEmpty(matchCode)) return new ArrayList<>(0);
        return this.lambdaQuery()
                .eq(AuditFeeCheckCost::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeCheckCost::getAuditFeeCheckCode,matchCode)
                .list();
    }

    public List<AuditFeeCheckCost> findByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditFeeCheckCost::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeCheckCost::getAuditFeeCheckCode,matchCodes)
                .list();
    }

    public List<String> findCompanyCostCodeByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return new ArrayList<>(0);
        }
        List<AuditFeeCheckCost> list = this.lambdaQuery()
            .select(AuditFeeCheckCost::getCompanyCostCode)
            .eq(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeCheckCost::getAuditFeeCheckCode, matchCodes)
            .list();
        if (CollectionUtils.isEmpty(matchCodes)) {
            return new ArrayList<>(0);
        }
        return list.stream().map(AuditFeeCheckCost::getCompanyCostCode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void updateDelFlagByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isNotEmpty(matchCodes)) {
            this.lambdaUpdate()
                .set(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeCheckCost::getAuditFeeCheckCode, matchCodes)
                .update();
        }
    }

    public void updateDelFlagByMatchCodes(List<String> companyCostCodes, String matchCode) {
        if (CollectionUtils.isNotEmpty(companyCostCodes) && matchCode != null) {
            this.lambdaUpdate()
                .set(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeCheckCost::getAuditFeeCheckCode, matchCode)
                .in(AuditFeeCheckCost::getCompanyCostCode, companyCostCodes)
                .update();
        }
    }

    public void cleanPosMatchRemarkByMatchCodes(List<String> matchCodes) {
        this.lambdaUpdate()
            .set(AuditFeeCheckCost::getPosRemark, "")
            .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeCheckCost::getAuditFeeCheckCode, matchCodes)
            .update();
    }

    /**
     * 删除拉取阶段拉取到但是已经被使用的费用单数据
     * @param md5UniqueKeyList
     */
    public void deleteUsedCosts(List<String> md5UniqueKeyList) {
        if (CollectionUtils.isEmpty(md5UniqueKeyList)) return;
        this.baseMapper.deleteUsedCosts(md5UniqueKeyList);
    }

    public AuditFeeCheckCost findOneByMd5UniqueKey(String md5UniqueKey) {
        if (md5UniqueKey == null) return null;
        LambdaQueryWrapper<AuditFeeCheckCost> query = new LambdaQueryWrapper<>();
        query.eq(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        query.eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode());
        query.eq(AuditFeeCheckCost::getAuditFeeCheckCode, AuditFeeCheckCost.MATCH_CODE_NULL);
        query.eq(AuditFeeCheckCost::getMd5UniqueKey, md5UniqueKey);
        query.last("limit 1");
        return this.getOne(query);
    }

    public List<String> findCompanyCostCodesByMd5UniqueKey(String md5UniqueKey) {
        if (md5UniqueKey == null) return Collections.emptyList();
        List<AuditFeeCheckCost> list = this.lambdaQuery()
            .select(AuditFeeCheckCost::getCompanyCostCode)
            .eq(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
            .eq(AuditFeeCheckCost::getMd5UniqueKey, md5UniqueKey)
            .list();
        if (CollectionUtils.isEmpty(list)) return Collections.emptyList();
        return list.stream().map(AuditFeeCheckCost::getCompanyCostCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public AuditFeeCheckCost findSumAmountByMd5UniqueKey(String md5UniqueKey) {
        if (md5UniqueKey == null) return null;
        return this.baseMapper.findSumAmountByMd5UniqueKey(md5UniqueKey, TenantUtils.getTenantCode());
    }

    public void updateMatchedByMd5UniqueKey(String md5UniqueKey, String matchCode) {
        if (md5UniqueKey == null || matchCode == null) return;
        this.lambdaUpdate()
            .set(AuditFeeCheckCost::getAuditFeeCheckCode, matchCode)
            .eq(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
            .eq(AuditFeeCheckCost::getAuditFeeCheckCode, AuditFeeCheckCost.MATCH_CODE_NULL)
            .eq(AuditFeeCheckCost::getMd5UniqueKey, md5UniqueKey)
            .update();
    }

    public boolean updatePosRemarkByMatchCodeList(List<String> matchCodeList, String posRemark) {
        if (CollectionUtils.isEmpty(matchCodeList)) return true;
        return this.lambdaUpdate()
            .set(AuditFeeCheckCost::getPosRemark, posRemark)
            .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeCheckCost::getAuditFeeCheckCode, matchCodeList)
            .update();
    }

    public List<String> findMatchCodesByCostCode(List<String> deductionCodeList) {
        if (CollectionUtils.isEmpty(deductionCodeList)) {
            return new ArrayList<>(0);
        }
        QueryWrapper<AuditFeeCheckCost> wrapper = new QueryWrapper<>();
        wrapper.select("DISTINCT audit_fee_check_code").lambda()
            .eq(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeCheckCost::getCompanyCostCode, deductionCodeList);
        List<AuditFeeCheckCost> list = this.list(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>(0);
        }
        return list.stream().map(AuditFeeCheckCost::getAuditFeeCheckCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public AuditFeeCheckCost findByCompanyCode(String companyCode) {
        LambdaQueryWrapper<AuditFeeCheckCost> query = new LambdaQueryWrapper<>();
        query.eq(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        query.eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode());
        query.eq(AuditFeeCheckCost::getCompanyCostCode, companyCode);
        query.last("limit 1");
        return this.getOne(query);
    }

    public List<String> findExistByCompanyCodes(List<String> companyCodes) {
        QueryWrapper<AuditFeeCheckCost> wrapper = new QueryWrapper<>();
        wrapper.select("DISTINCT company_cost_code").lambda()
            .eq(AuditFeeCheckCost::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeCheckCost::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeCheckCost::getCompanyCostCode, companyCodes);
        List<AuditFeeCheckCost> list = this.list(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>(0);
        }
        return list.stream().map(AuditFeeCheckCost::getCompanyCostCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public AuditFeeCheckCost initOne() {
        AuditFeeCheckCost cost = new AuditFeeCheckCost();
        cost.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        cost.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        cost.setTenantCode(TenantUtils.getTenantCode());
        return cost;
    }
}
