package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlanShare;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckDetailPlanMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对关联细案表(repository)
 *
 * @author makejava
 * @date 2022-12-06 14:19:02
 */
@Component
public class AuditFeeCheckDetailPlanRepository extends ServiceImpl<AuditFeeCheckDetailPlanMapper, AuditFeeCheckDetailPlan> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private AuditFeeCheckDetailPlanShareRepository auditFeeCheckDetailPlanShareRepository;

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeCheckDetailPlanVo> findByConditions(Page<AuditFeeCheckDetailPlanVo> page, AuditFeeCheckDetailPlanDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeCheckDetailPlan findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeCheckDetailPlan> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeCheckDetailPlan::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeCheckDetailPlan::getId, ids)
                .set(AuditFeeCheckDetailPlan::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeCheckDetailPlan::getId, ids)
                .set(AuditFeeCheckDetailPlan::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    public List<AuditFeeCheckDetailPlan> findDetailByMatchCode(String matchCode) {
        if (StringUtils.isEmpty(matchCode)){
            return Lists.newArrayList();
        }
        return  this.lambdaQuery()
                .eq(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCode)
                .eq(AuditFeeCheckDetailPlan::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckDetailPlan::getTenantCode,TenantUtils.getTenantCode())
                .list();
    }

    public List<AuditFeeCheckDetailPlanVo> findDetailPlanByMatchCode(String matchCode) {
        if (StringUtils.isEmpty(matchCode)){
            return Lists.newArrayList();
        }
        return baseMapper.findDetailPlanByMatchCode(matchCode, TenantUtils.getTenantCode());
    }

    public List<AuditFeeCheckDetailPlan> findDetailByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)){
            return Lists.newArrayList();
        }
        return  this.lambdaQuery()
                .in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodes)
                .eq(AuditFeeCheckDetailPlan::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckDetailPlan::getTenantCode,TenantUtils.getTenantCode())
                .list();
    }

    public List<AuditFeeCheckDetailPlan> findByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        return lambdaQuery()
                .eq(AuditFeeCheckDetailPlan::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckDetailPlan::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodes)
                .list();
    }

    public List<String> findDetailPlanItemCodeByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return new ArrayList<>(0);
        }
        List<AuditFeeCheckDetailPlan> list = lambdaQuery().select(
                AuditFeeCheckDetailPlan::getDetailPlanItemCode)
            .eq(AuditFeeCheckDetailPlan::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeCheckDetailPlan::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodes)
            .list();
        if (CollectionUtils.isEmpty(list)) return new ArrayList<>(0);
        return list.stream().map(AuditFeeCheckDetailPlan::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<AuditFeeCheckDetailPlan> findByDetailPlanItemCodeList(List<String> detailPlanItemCodeList) {
        return this.lambdaQuery()
                .in(AuditFeeCheckDetailPlan::getDetailPlanItemCode, detailPlanItemCodeList)
                .eq(AuditFeeCheckDetailPlan::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckDetailPlan::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public int getCountByAuditCode(List<String> auditCodes){
        return this.lambdaQuery()
                .eq(AuditFeeCheckDetailPlan::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckDetailPlan::getTenantCode,TenantUtils.getTenantCode())
                .in(AuditFeeCheckDetailPlan::getAuditCode, auditCodes)
                .count();
    }

    public void updateStatusByAuditCodes(List<String> auditCodes){
        this.lambdaUpdate()
                .eq(AuditFeeCheckDetailPlan::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckDetailPlan::getTenantCode,TenantUtils.getTenantCode())
                .in(AuditFeeCheckDetailPlan::getAuditCode, auditCodes)
                .set(AuditFeeCheckDetailPlan::getIsCreatedByFee, BooleanEnum.FALSE.getCapital())
//                .set(AuditFeeCheckDetailPlan::getIsCreatedBySettlement, BooleanEnum.FALSE.getCapital())
                .set(AuditFeeCheckDetailPlan::getAuditDetailCode,StringUtils.EMPTY)
                .set(AuditFeeCheckDetailPlan::getAuditCode,StringUtils.EMPTY)
                .update();
    }

    public void updateDelFlagByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        this.lambdaUpdate()
                .set(AuditFeeCheckDetailPlan::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .eq(AuditFeeCheckDetailPlan::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodes)
                .update();
        // 连带删除该细案分摊的数据
        auditFeeCheckDetailPlanShareRepository.deleteByMatchCodes(matchCodes);
    }

    public List<String> findNoConfirmByDetailPlanItemCodeList(List<String> detailPlanItemCodes) {
        return baseMapper.findNoConfirmByDetailPlanItemCodeList(detailPlanItemCodes,TenantUtils.getTenantCode());
    }

    public void updateMatchCodeByMatchCostAndPos(String matchCode, List<String> posIds) {
        this.lambdaUpdate()
                .set(AuditFeeCheckDetailPlan::getAuditFeeCheckCode,matchCode)
                .eq(AuditFeeCheckDetailPlan::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckDetailPlan::getTenantCode,TenantUtils.getTenantCode())
                .in(AuditFeeCheckDetailPlan::getPosId,posIds)
                .update();

        //this.baseMapper.updateMatchCodeByMatchCostAndPos(matchCode,posIds ,TenantUtils.getTenantCode());
    }

    public void removeByMatchCodeList(List<String> matchCodeList){
        if (CollectionUtils.isEmpty(matchCodeList)){
            return;
        }
        // 先删除核对编号下的所有匹配上的细案
        LambdaUpdateWrapper<AuditFeeCheckDetailPlan> logicRemoveDetailPlan = new LambdaUpdateWrapper<>();
        logicRemoveDetailPlan.in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodeList);
        logicRemoveDetailPlan.eq(AuditFeeCheckDetailPlan::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        logicRemoveDetailPlan.set(AuditFeeCheckDetailPlan::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        this.update(logicRemoveDetailPlan);

        // 删除对应的分摊
        AuditFeeCheckDetailPlanShare auditFeeCheckDetailPlanShare = new AuditFeeCheckDetailPlanShare();
        auditFeeCheckDetailPlanShare.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        LambdaUpdateWrapper<AuditFeeCheckDetailPlanShare> logicRemoveDetailPlanShare = new LambdaUpdateWrapper<>();
        logicRemoveDetailPlanShare.in(AuditFeeCheckDetailPlanShare::getAuditFeeCheckCode, matchCodeList);
        logicRemoveDetailPlanShare.eq(AuditFeeCheckDetailPlanShare::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        logicRemoveDetailPlanShare.set(AuditFeeCheckDetailPlanShare::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        auditFeeCheckDetailPlanShareRepository.update(logicRemoveDetailPlanShare);
    }

    public void save(List<AuditFeeCheckDetailPlanVo> detailPlanVos){
        if (CollectionUtils.isEmpty(detailPlanVos)) return;
        Collection<AuditFeeCheckDetailPlan> auditFeeCheckDetailPlans = nebulaToolkitService.copyCollectionByWhiteList(detailPlanVos, AuditFeeCheckDetailPlanVo.class, AuditFeeCheckDetailPlan.class, HashSet.class, ArrayList.class);
        this.saveBatch(auditFeeCheckDetailPlans);
    }

    public void saveWithShare(List<AuditFeeCheckDetailPlanVo> detailPlanVos){
        if (CollectionUtils.isEmpty(detailPlanVos)) return;
        this.save(detailPlanVos);

        // 保存分摊
        List<AuditFeeCheckDetailPlanShare> shareList = detailPlanVos.stream().map(e -> {
            AuditFeeCheckDetailPlanShare detailPlanShare = new AuditFeeCheckDetailPlanShare();
            detailPlanShare.setAuditFeeCheckCode(e.getAuditFeeCheckCode());
            detailPlanShare.setDetailPlanItemCode(e.getDetailPlanItemCode());
            detailPlanShare.setAuditFeeCheckShareAmount(e.getAuditFeeCheckShareAmount());
            detailPlanShare.setToBeSupplementedAmount(e.getToBeSupplementedAmount());
            detailPlanShare.setThisAuditAmount(e.getThisAuditAmount());
            detailPlanShare.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detailPlanShare.setTenantCode(TenantUtils.getTenantCode());
            detailPlanShare.setId(null);
            return detailPlanShare;
        }).collect(Collectors.toList());
        auditFeeCheckDetailPlanShareRepository.saveBatch(shareList);
    }

    public AuditFeeCheckDetailPlan initOne() {
        AuditFeeCheckDetailPlan detailPlan = new AuditFeeCheckDetailPlan();
        detailPlan.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailPlan.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailPlan.setTenantCode(TenantUtils.getTenantCode());
        return detailPlan;
    }

    public List<AuditFeeCheckDetailPlanVo> findActivityAndShareByActivityItemCodes(List<String> activityItemCodes) {
        if (CollectionUtils.isEmpty(activityItemCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckDetailPlanVo> list = this.baseMapper.findActivityAndShareByActivityItemCodes(activityItemCodes,TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}
