package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlanShare;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckDetailPlanShareMapper;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对关联细案表(repository)
 *
 * @author makejava
 * @date 2022-12-06 14:19:02
 */
@Component
public class AuditFeeCheckDetailPlanShareRepository extends ServiceImpl<AuditFeeCheckDetailPlanShareMapper, AuditFeeCheckDetailPlanShare> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        this.lambdaUpdate()
            .set(AuditFeeCheckDetailPlanShare::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
            .eq(AuditFeeCheckDetailPlanShare::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeCheckDetailPlanShare::getAuditFeeCheckCode, matchCodes)
            .update();
    }
}
