package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDiff;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckDiffMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDiffDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDiffVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对关联差异费用(repository)
 *
 * @author makejava
 * @date 2022-11-14 17:32:57
 */
@Component
public class AuditFeeCheckDiffRepository extends ServiceImpl<AuditFeeCheckDiffMapper, AuditFeeCheckDiff> {

  /**
   * 分页 核对暂时保存的费用差异
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<AuditFeeCheckDiffVo> findByConditions(Page<AuditFeeCheckDiffVo> page, AuditFeeCheckDiffDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<AuditFeeCheckDiffVo> findByIds(List<String> ids) {
    // 要查询分摊表的金额
      if (CollectionUtils.isEmpty(ids)) {
          return new ArrayList<>(0);
      }
    return this.baseMapper.findByIds(ids);
  }

  /**
   * 根据费用核对编码查询差异费用列表
   *
   * @param matchCode 费用核对编码
   * @return 差异费用列表
   */
  public List<AuditFeeCheckDiffVo> findDetailByMatchCode(String matchCode) {
      if (StringUtils.isEmpty(matchCode)) {
          return new ArrayList<>(0);
      }
    // 要查询分摊表的金额
    return this.baseMapper.findDetailByMatchCode(matchCode);
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(AuditFeeCheckDiff::getId, ids)
        .set(AuditFeeCheckDiff::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(AuditFeeCheckDiff::getId, ids)
        .set(AuditFeeCheckDiff::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param matchCodes
   */
  public void updateDelFlagByMatchCodes(List<String> matchCodes) {
    this.lambdaUpdate()
        .set(AuditFeeCheckDiff::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .eq(AuditFeeCheckDiff::getTenantCode, TenantUtils.getTenantCode())
        .in(AuditFeeCheckDiff::getAuditFeeCheckDeductCode, matchCodes)
        .update();
  }
}
