package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDiff;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDiffShare;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckDiffShareMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对关联差异费用分摊(repository)
 *
 * @author makejava
 * @date 2022-11-14 17:32:57
 */
@Component
public class AuditFeeCheckDiffShareRepository extends ServiceImpl<AuditFeeCheckDiffShareMapper, AuditFeeCheckDiffShare> {

  public void updateDelFlagByMatchCodes(List<String> matchCodes) {
    this.lambdaUpdate()
        .set(AuditFeeCheckDiffShare::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .eq(AuditFeeCheckDiffShare::getTenantCode, TenantUtils.getTenantCode())
        .in(AuditFeeCheckDiffShare::getAuditFeeCheckDeductCode, matchCodes)
        .update();
  }
}
