package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosHead;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckPosHeadMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosHeadDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosHeadVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * 核销费用核对POS汇总表数据库访问层
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-11-06 19:46
 */
@Component
public class AuditFeeCheckPosHeadRepository extends ServiceImpl<AuditFeeCheckPosHeadMapper, AuditFeeCheckPosHead> {


    public Page<AuditFeeCheckPosHeadVo> findByConditions(Pageable pageable, AuditFeeCheckPosHeadDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<AuditFeeCheckPosHeadVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckPosHeadDto());
        if (StringUtils.isEmpty(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeCheckPosHead findByIdOrCode(String id, String matchHeadCode) {
        if (StringUtils.isEmpty(id)
                && StringUtils.isEmpty(matchHeadCode)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(StringUtils.isNotEmpty(id), AuditFeeCheckPosHead::getId, id)
                .eq(StringUtils.isNotEmpty(matchHeadCode), AuditFeeCheckPosHead::getMatchHeadCode, matchHeadCode)
                .one();
    }
}
