package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosLedger;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckPosLedgerMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
 * POS活动核对和差异费用关系表数据库访问层
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-10-06 15:29
 */
@Component
public class AuditFeeCheckPosLedgerRepository extends ServiceImpl<AuditFeeCheckPosLedgerMapper, AuditFeeCheckPosLedger> {


    public List<AuditFeeCheckPosLedger> findByMatchCodeList(List<String> matchCodeList) {
        if (CollectionUtil.isEmpty(matchCodeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(AuditFeeCheckPosLedger::getMatchCode, matchCodeList)
                .eq(AuditFeeCheckPosLedger::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeCheckPosLedger::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public void removeByMatchCodeList(List<String> matchCodeList) {
        if (CollectionUtil.isEmpty(matchCodeList)) {
            return;
        }
        this.lambdaUpdate()
                .in(AuditFeeCheckPosLedger::getMatchCode, matchCodeList)
                .eq(AuditFeeCheckPosLedger::getTenantCode, TenantUtils.getTenantCode())
                .remove();
    }

    public List<AuditFeeCheckPosLedger> findByMatchHeadCode(String matchHeadCode) {
        if (StringUtil.isEmpty(matchHeadCode)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(AuditFeeCheckPosLedger::getMatchHeadCode, matchHeadCode)
                .eq(AuditFeeCheckPosLedger::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeCheckPosLedger::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }
}
