package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckPosMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @Description:核销费用核对POS表数据库访问层
 * @Author qiancheng
 * @Date 2023/5/29
 */
@Component
public class AuditFeeCheckPosRepository extends ServiceImpl<AuditFeeCheckPosMapper, AuditFeeCheckPos> {

    public Page<AuditFeeCheckPosVo> findByConditions(Pageable pageable, AuditFeeCheckPosDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<AuditFeeCheckPosVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckPosDto());
        if (StringUtils.isEmpty(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.baseMapper.findByConditions(page, dto);
    }

    public List<AuditFeeCheckPos> findByPosId(List<String> posIds) {
        return this.lambdaQuery()
                .in(AuditFeeCheckPos::getId, posIds)
                .eq(AuditFeeCheckPos::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckPos::getTenantCode, TenantUtils.getTenantCode())
                .list();

    }

    public List<AuditFeeCheckPos> findByMatchCode(String matchCode) {
        if (StringUtils.isEmpty(matchCode)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(AuditFeeCheckPos::getMatchCode, matchCode)
                .eq(AuditFeeCheckPos::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckPos::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public List<AuditFeeCheckPos> findByMatchCodeList(List<String> matchCodeList) {
        if (CollectionUtil.isEmpty(matchCodeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(AuditFeeCheckPos::getMatchCode, matchCodeList)
                .eq(AuditFeeCheckPos::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckPos::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public void updateStatusByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        this.lambdaUpdate()
                .set(AuditFeeCheckPos::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .set(AuditFeeCheckPos::getIsMatchCost, BooleanEnum.FALSE.getCapital())
                .set(AuditFeeCheckPos::getIsMatchActivity, BooleanEnum.FALSE.getCapital())
                .set(AuditFeeCheckPos::getCompanyCostCode, null)
                .set(AuditFeeCheckPos::getItemIndex, null)
                .set(AuditFeeCheckPos::getMatchCode, null)
                .eq(AuditFeeCheckPos::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeCheckPos::getMatchCode, matchCodes)
                .update();

    }

    public void updateRemark(List<String> ids, String remark) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        this.lambdaUpdate()
                .set(AuditFeeCheckPos::getRemark, remark)
                .in(AuditFeeCheckPos::getId, ids)
                .eq(AuditFeeCheckPos::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckPos::getTenantCode, TenantUtils.getTenantCode())
                .update();
    }

    /**
     * 确认匹配
     *
     * @param dto
     */
    public void updateFeeCheckPos(AuditFeeCheckPosDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        if (CollectionUtil.isEmpty(dto.getIds())) {
            return;
        }
        this.lambdaUpdate()
                .in(AuditFeeCheckPos::getId, dto.getIds())
                .set(AuditFeeCheckPos::getMatchHeadCode, dto.getMatchHeadCode())
                .set(AuditFeeCheckPos::getMatchStatus, dto.getMatchStatus())
                .set(AuditFeeCheckPos::getTotalDiffFinalAmount, dto.getTotalDiffFinalAmount())
                .set(AuditFeeCheckPos::getDiffUse, dto.getDiffUse())
                .set(AuditFeeCheckPos::getMatchTime, new Date())
                .set(AuditFeeCheckPos::getRemark, dto.getRemark())
                .update();
    }

    /**
     * 根据id或者编码查询详情
     *
     * @param id
     * @param matchCode
     * @return
     */
    public AuditFeeCheckPos findByIdOrCode(String id, String matchCode) {
        if (StringUtils.isEmpty(id)
                && StringUtils.isEmpty(matchCode)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(StringUtils.isNotEmpty(id), AuditFeeCheckPos::getId, id)
                .eq(StringUtils.isNotEmpty(matchCode), AuditFeeCheckPos::getMatchCode, matchCode)
                .one();
    }

    /**
     * 根据ID 获取ID集合 验证数据是否存在!
     *
     * @param idList
     * @return
     */
    public List<AuditFeeCheckPos> listIdsByIds(List<String> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(AuditFeeCheckPos::getId, idList)
                .list();
    }

    /**
     * 根据ID 更新KMS信息
     *
     * @param entity
     */
    public void updateAmountById(AuditFeeCheckPos entity) {
        if (Objects.isNull(entity)
                || StringUtils.isEmpty(entity.getId())) {
            return;
        }
        this.baseMapper.updateAmountById(entity);
    }

    /**
     * 根据匹配的费用单编号查询
     *
     * @param feeCheckMatchCodes
     * @return
     */
    public List<AuditFeeCheckPos> findByFeeCheckMatchCodes(List<String> feeCheckMatchCodes) {
        if (CollectionUtils.isEmpty(feeCheckMatchCodes)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
            .in(AuditFeeCheckPos::getFeeCheckMatchCode, feeCheckMatchCodes)
            .eq(AuditFeeCheckPos::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeCheckPos::getTenantCode, TenantUtils.getTenantCode())
            .list();
    }

    /**
     * 计算差异总金额
     *
     * @param idList
     */
    public void computeTotalDiffAmount(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        this.baseMapper.computeTotalDiffAmount(idList);
    }
}
