package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheck;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对主表(repository)
 *
 * @author makejava
 * @date 2022-11-14 16:56:07
 */
@Component
public class AuditFeeCheckRepository extends ServiceImpl<AuditFeeCheckMapper, AuditFeeCheck> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeCheckVo> findByConditions(Page<AuditFeeCheckVo> page, AuditFeeCheckDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeCheck findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeCheck> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeCheck::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeCheck::getId, ids)
                .set(AuditFeeCheck::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeCheck::getId, ids)
                .set(AuditFeeCheck::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    public void updateDelFlagByMatchCodes(List<String> matchCodeList) {
        if (CollectionUtils.isEmpty(matchCodeList)) return;
        this.lambdaUpdate()
                .in(AuditFeeCheck::getMatchCode, matchCodeList)
                .eq(AuditFeeCheck::getTenantCode, TenantUtils.getTenantCode())
                .set(AuditFeeCheck::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    public List<AuditFeeCheck> getPlanCheckAccountData(AuditFeeCheckDto dto) {
        return this.lambdaQuery()
                .eq(AuditFeeCheck::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheck::getTenantCode,TenantUtils.getTenantCode())
                .eq(AuditFeeCheck::getMatchStatus, MatchStatusEnum.MATCHED.getCode())
                .and(e -> e
                        .ne(AuditFeeCheck::getIsConfirm, BooleanEnum.TRUE.getCapital())
                        .or()
                        .isNull(AuditFeeCheck::getIsConfirm)
                )
                .list();
    }

    public List<AuditFeeCheck> findByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) return new ArrayList<>(0);
        return this.lambdaQuery()
                .eq(AuditFeeCheck::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheck::getTenantCode,TenantUtils.getTenantCode())
                .in(AuditFeeCheck::getMatchCode,matchCodes)
                .list();
    }

    public List<String> findConfirmedByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) return new ArrayList<>(0);
        List<AuditFeeCheck> list = this.lambdaQuery().select(AuditFeeCheck::getMatchCode)
            .eq(AuditFeeCheck::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeCheck::getIsConfirm, BooleanEnum.TRUE.getCapital())
            .eq(AuditFeeCheck::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeCheck::getMatchCode, matchCodes)
            .list();
        if (CollectionUtils.isEmpty(list)) return new ArrayList<>(0);
        return list.stream().map(AuditFeeCheck::getMatchCode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String findMappingCode(String matchCode) {
        return this.baseMapper.findMappingCode(matchCode);
    }

    public void diffDisposeDeletedUpdateStatus(List<String> matchCodes) {
        this.lambdaUpdate()
                .eq(AuditFeeCheck::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheck::getTenantCode,TenantUtils.getTenantCode())
                .in(AuditFeeCheck::getMatchCode, matchCodes)
                .set(AuditFeeCheck::getIsAlreadyDiff, BooleanEnum.FALSE.getCapital())
                .update();
    }

    public Page<AuditFeeCheckVo> findByConditionsForEct(Page<AuditFeeCheckVo> page, AuditFeeCheckSelectDto dto) {
        return this.baseMapper.findByConditionsForEct(page,dto);
    }

    public AuditFeeCheck findByMatchCode(String matchCode) {
        return this.lambdaQuery()
                .eq(AuditFeeCheck::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheck::getTenantCode,TenantUtils.getTenantCode())
                .eq(AuditFeeCheck::getMatchCode,matchCode)
                .one();
    }

    /**
     * 查询所有待确认差异的
     * @return
     */
    public List<AuditFeeCheck> findNotConfirmedDiff(String templateCode) {
        if (StringUtil.isEmpty(templateCode)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditFeeCheck::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheck::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeCheck::getIsConfirmDiff, BooleanEnum.FALSE.getCapital())
                .eq(AuditFeeCheck::getIsConfirm, BooleanEnum.FALSE.getCapital())
                .eq(AuditFeeCheck::getMatchTemplateCode, templateCode)
                .list();
    }

    public AuditFeeCheck initOne() {
        AuditFeeCheck feeCheck = new AuditFeeCheck();
        feeCheck.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        feeCheck.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        feeCheck.setTenantCode(TenantUtils.getTenantCode());
        return feeCheck;
    }

    public Page<String> findNotConfirmedDiffPage(Pageable pageable,AuditFeeCheckDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1,50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckDto());
        Page<String> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (StringUtil.isEmpty(dto.getTenantCode())){
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.baseMapper.findNotConfirmedDiffPage(page,dto);
    }
}
