package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckStatement;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckStatementMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckStatementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckStatementVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * 核销费用核对关联结算单单表(数据源至KMS)(repository)
 *
 * @author makejava
 * @date 2022-12-06 14:20:22
 */
@Component
@Deprecated
public class AuditFeeCheckStatementRepository extends ServiceImpl<AuditFeeCheckStatementMapper, AuditFeeCheckStatement> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeCheckStatementVo> findByConditions(Page<AuditFeeCheckStatementVo> page, AuditFeeCheckStatementDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeCheckStatement findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeCheckStatement> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeCheckStatement::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeCheckStatement::getId, ids)
                .set(AuditFeeCheckStatement::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeCheckStatement::getId, ids)
                .set(AuditFeeCheckStatement::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    public List<AuditFeeCheckStatement> findDetailByMatchCode(String matchCode) {
        return this.lambdaQuery()

                .eq(AuditFeeCheckStatement::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckStatement::getAuditFeeCheckCode, matchCode)
                .list();
    }

    public void deleteByAuditFeeCheckCodeList(List<String> auditFeeCheckCodeList) {
        this.lambdaUpdate().in(AuditFeeCheckStatement::getAuditFeeCheckCode, auditFeeCheckCodeList).remove();
    }

    public List<AuditFeeCheckStatement> findDetailByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        return lambdaQuery()
                .eq(AuditFeeCheckStatement::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeCheckStatement::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeCheckStatement::getAuditFeeCheckCode,matchCodes)
                .list();
    }

    public Integer getUnmatchedStatementTotal(AuditFeeCheckStatementDto dto) {
        return this.baseMapper.getUnmatchedStatementTotal(dto);
    }

    public List<AuditFeeCheckStatementVo> findUnmatchedStatement(AuditFeeCheckStatementDto dto, int pageNumber, int pageSize) {
        return this.baseMapper.findUnmatchedStatement(dto,pageNumber,pageSize);
    }
}
