package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeVerifyDecide;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeVerifyDecideMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.IsPushEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideVo;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/9 17:09
 * @description：扣费核定
 */
@Component
public class AuditFeeVerifyDecideRepository extends ServiceImpl<AuditFeeVerifyDecideMapper, AuditFeeVerifyDecide> {

    public Page<AuditFeeVerifyDecideVo> findByConditions(Page<AuditFeeVerifyDecideVo> page, AuditFeeVerifyDecideDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public void updateWholeAudit(List<String> idList, String wholeAudit) {
        this.lambdaUpdate()
                .set(AuditFeeVerifyDecide::getWholeAudit,wholeAudit)
                .eq(AuditFeeVerifyDecide::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeVerifyDecide::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeVerifyDecide::getId,idList)
                .update();
    }

    public List<AuditFeeVerifyDecideVo> findWillPushAuditData(AuditFeeVerifyDecideDto dto) {
        return this.baseMapper.findWillPushAuditData(dto);
    }

    public void updatePushAuditResult(List<AuditCustomerDetailDto> auditCustomerDetailList, String auditCode, String status) {
        this.baseMapper.updatePushAuditResult(auditCustomerDetailList,auditCode,status,TenantUtils.getTenantCode());
    }

    public void updateStatusByAudit(List<String> auditCodeList, List<String> auditDetailCodeList, String tenantCode) {
        this.lambdaUpdate()
                .set(AuditFeeVerifyDecide::getIsPush, IsPushEnum.WAIT.getCode())
                .set(AuditFeeVerifyDecide::getAuditCode,null)
                .set(AuditFeeVerifyDecide::getAuditDetailCode,null)
                .eq(StringUtils.isNotBlank(tenantCode),AuditFeeVerifyDecide::getTenantCode,tenantCode)
                .in(!CollectionUtils.isEmpty(auditCodeList),AuditFeeVerifyDecide::getAuditCode,auditCodeList)
                .in(!CollectionUtils.isEmpty(auditDetailCodeList),AuditFeeVerifyDecide::getAuditDetailCode,auditDetailCodeList)
                .update();
    }
}
