package com.biz.crm.tpm.business.audit.fee.local.repository.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import java.util.List;

import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDispose;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.local.mapper.dispose.AuditFeeDiffDisposeDetailMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

/**
 * 核销差异费用处理明细(repository)
 *
 * @author liuyifan
 * @date 2022-12-24 13:56:10
 */
@Component
public class AuditFeeDiffDisposeDetailRepository extends ServiceImpl<AuditFeeDiffDisposeDetailMapper, AuditFeeDiffDisposeDetail> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeDiffDisposeDetailVo> findByConditions(Page<AuditFeeDiffDisposeDetailVo> page, AuditFeeDiffDisposeDetailDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeDiffDisposeDetail findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeDiffDisposeDetail> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeDiffDisposeDetail::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeDiffDisposeDetail::getId, ids)
                .set(AuditFeeDiffDisposeDetail::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeDiffDisposeDetail::getId, ids)
                .set(AuditFeeDiffDisposeDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    public List<AuditFeeDiffDisposeDetail> findDetailByDiffDisposeCode(String feeDiffDisposeCode) {
        return this.lambdaQuery().eq(AuditFeeDiffDisposeDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeDiffDisposeDetail::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeDiffDisposeDetail::getFeeDiffDisposeCode, feeDiffDisposeCode)
                .list();
    }


    /**
     * 根据差异费用处理编码逻辑删除差异费用处理明细数据
     *
     * @param feeDiffDisposeCode 费用差异处理编码
     */
    public void deleteByDiffDisposeCode(String feeDiffDisposeCode) {
        this.lambdaUpdate()
                .eq(AuditFeeDiffDisposeDetail::getFeeDiffDisposeCode, feeDiffDisposeCode)
                .eq(AuditFeeDiffDisposeDetail::getTenantCode, TenantUtils.getTenantCode())
                .set(AuditFeeDiffDisposeDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode())

                .update();
    }

    /**
     * 查询明细
     * @param dto
     * @return {@link List}<{@link AuditFeeDiffDisposeDetailVo}>
     */
    public List<AuditFeeDiffDisposeDetail> findByFeeDiffDisposeCode(AuditFeeDiffDisposeDetailDto dto) {
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.lambdaQuery()
            .eq(AuditFeeDiffDisposeDetail::getFeeDiffDisposeCode, dto.getFeeDiffDisposeCode())
            .eq(AuditFeeDiffDisposeDetail::getDelFlag, dto.getDelFlag())
            .eq(AuditFeeDiffDisposeDetail::getTenantCode, dto.getTenantCode())
            .list();
    }

    public void deleteByDiffDisposeCodes(List<String> feeDifDisposeCodes) {
        this.lambdaUpdate()
                .in(AuditFeeDiffDisposeDetail::getFeeDiffDisposeCode, feeDifDisposeCodes)
                .eq(AuditFeeDiffDisposeDetail::getTenantCode, TenantUtils.getTenantCode())
                .set(AuditFeeDiffDisposeDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }
}
