package com.biz.crm.tpm.business.audit.fee.local.repository.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedger;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedgerItem;
import com.biz.crm.tpm.business.audit.fee.local.mapper.dispose.AuditFeeDiffDisposeLedgerItemMapper;
import com.biz.crm.tpm.business.audit.fee.local.mapper.dispose.AuditFeeDiffDisposeLedgerMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 核销差异费用处理预算汇总信息(repository)
 *
 * @author liuyifan
 * @date 2022-12-24 13:55:44
 */
@Component
public class AuditFeeDiffDisposeLedgerItemRepository extends ServiceImpl<AuditFeeDiffDisposeLedgerItemMapper, AuditFeeDiffDisposeLedgerItem> {

    /**
     * 逻辑删除差异费用处理预算编码
     * @param feeDiffDisposeCode
     */
    public void deleteByAuditFeeDiffDisposeCode(String feeDiffDisposeCode) {
        this.lambdaUpdate()
            .eq(AuditFeeDiffDisposeLedgerItem::getTenantCode, TenantUtils.getTenantCode())
            .eq(AuditFeeDiffDisposeLedgerItem::getFeeDiffDisposeCode, feeDiffDisposeCode)
            .set(AuditFeeDiffDisposeLedgerItem::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
            .update();
    }

    /**
     * 查询差异费用明细
     * @param dto
     * @return {@link List}<{@link AuditFeeDiffDisposeLedgerItem}>
     */
    public List<AuditFeeDiffDisposeLedgerItem> findByFeeDiffDisposeCode(AuditFeeDiffDisposeDetailDto dto) {
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.lambdaQuery()
            .eq(AuditFeeDiffDisposeLedgerItem::getFeeDiffDisposeCode, dto.getFeeDiffDisposeCode())
            .eq(AuditFeeDiffDisposeLedgerItem::getDelFlag, dto.getDelFlag())
            .eq(AuditFeeDiffDisposeLedgerItem::getTenantCode, dto.getTenantCode())
            .list();
    }

    public void updateDelFlagByFeeDiffDisposeCodes(List<String> feeDifDisposeCodes) {
        this.lambdaUpdate()
                .eq(AuditFeeDiffDisposeLedgerItem::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeDiffDisposeLedgerItem::getFeeDiffDisposeCode, feeDifDisposeCodes)
                .set(AuditFeeDiffDisposeLedgerItem::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();

    }
}
