package com.biz.crm.tpm.business.audit.fee.local.repository.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import java.util.List;

import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedger;
import com.biz.crm.tpm.business.audit.fee.local.mapper.dispose.AuditFeeDiffDisposeLedgerMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

/**
 * 核销差异费用处理预算汇总信息(repository)
 *
 * @author liuyifan
 * @date 2022-12-24 13:55:44
 */
@Component
public class AuditFeeDiffDisposeLedgerRepository extends ServiceImpl<AuditFeeDiffDisposeLedgerMapper, AuditFeeDiffDisposeLedger> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeDiffDisposeLedgerVo> findByConditions(Page<AuditFeeDiffDisposeLedgerVo> page, AuditFeeDiffDisposeLedgerDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeDiffDisposeLedger findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeDiffDisposeLedger> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeDiffDisposeLedger::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeDiffDisposeLedger::getId, ids)
                .set(AuditFeeDiffDisposeLedger::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeDiffDisposeLedger::getId, ids)
                .set(AuditFeeDiffDisposeLedger::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    /**
     * 获取差异费用处理预算列表
     *
     * @param feeDiffDisposeCode 费用差异处理代码
     * @return {@link List}<{@link AuditFeeDiffDisposeLedger}>
     */
    public List<AuditFeeDiffDisposeLedger> findDetailByDiffDisposeCode(String feeDiffDisposeCode) {
        return this.lambdaQuery()
                .eq(AuditFeeDiffDisposeLedger::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeDiffDisposeLedger::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeDiffDisposeLedger::getFeeDiffDisposeCode, feeDiffDisposeCode)
                .list();
    }


    /**
     * 逻辑删除差异费用处理预算编码
     *
     * @param feeDiffDisposeCode 差异费用处理编码
     */
    public void deleteByAuditFeeDiffDisposeCode(String feeDiffDisposeCode) {
        this.lambdaUpdate()
                .eq(AuditFeeDiffDisposeLedger::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeDiffDisposeLedger::getFeeDiffDisposeCode, feeDiffDisposeCode)
                .set(AuditFeeDiffDisposeLedger::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    public void updateDelFlagByFeeDiffDisposeCodes(List<String> feeDifDisposeCodes) {
        this.lambdaUpdate()
                .eq(AuditFeeDiffDisposeLedger::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeDiffDisposeLedger::getFeeDiffDisposeCode, feeDifDisposeCodes)
                .set(AuditFeeDiffDisposeLedger::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }
}
