package com.biz.crm.tpm.business.audit.fee.local.repository.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDispose;
import com.biz.crm.tpm.business.audit.fee.local.mapper.dispose.AuditFeeDiffDisposeMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

/**
 * 核销差异费用处理(repository)
 *
 * @author liuyifan
 * @date 2022-12-24 13:54:27
 */
@Component
public class AuditFeeDiffDisposeRepository extends ServiceImpl<AuditFeeDiffDisposeMapper, AuditFeeDiffDispose> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeDiffDisposeVo> findByConditions(Page<AuditFeeDiffDisposeVo> page, AuditFeeDiffDisposeDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeDiffDispose findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeDiffDispose> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeDiffDispose::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeDiffDispose::getId, ids)
                .set(AuditFeeDiffDispose::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeDiffDispose::getId, ids)
                .set(AuditFeeDiffDispose::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }


    /**
     * 根据处理编码查询差异处理详情
     *
     * @param businessNo 业务编码
     * @return {@link AuditFeeDiffDisposeVo}
     */
    public AuditFeeDiffDispose findDetailByDisposeCode(String businessNo) {
        return this.lambdaQuery()
                .eq(AuditFeeDiffDispose::getFeeDiffDisposeCode, businessNo)
                .eq(AuditFeeDiffDispose::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeDiffDispose::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }

    public void updateProcessStatusByCode(AuditFeeDiffDisposeDto dto) {
        this.lambdaUpdate()
                .set(AuditFeeDiffDispose::getProcessStatus,dto.getProcessStatus())
                .set(AuditFeeDiffDispose::getProcessNo,dto.getProcessNo())
                .eq(AuditFeeDiffDispose::getFeeDiffDisposeCode,dto.getFeeDiffDisposeCode())
                .eq(AuditFeeDiffDispose::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeDiffDispose::getTenantCode,TenantUtils.getTenantCode())
                .update();

    }

    public void updateProcessStatus(String processStatus, String processNo) {
        this.lambdaUpdate()
                .set(AuditFeeDiffDispose::getProcessStatus,processStatus)
                .eq(AuditFeeDiffDispose::getProcessNo,processNo)
                .eq(AuditFeeDiffDispose::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeDiffDispose::getTenantCode,TenantUtils.getTenantCode())
                .update();

    }
}
