package com.biz.crm.tpm.business.audit.fee.local.repository.ledger;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import java.util.ArrayList;
import java.util.List;

import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedgerDeduction;
import com.biz.crm.tpm.business.audit.fee.local.mapper.ledger.AuditFeeDiffLedgerDeductionMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerDeductionVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

/**
 * 核销差异费用扣减明细(repository)
 *
 * @author liuyifan
 * @date 2022-12-22 14:54:37
 */
@Component
public class AuditFeeDiffLedgerDeductionRepository extends ServiceImpl<AuditFeeDiffLedgerDeductionMapper, AuditFeeDiffLedgerDeduction> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeDiffLedgerDeductionVo> findByConditions(Page<AuditFeeDiffLedgerDeductionVo> page, AuditFeeDiffLedgerDeductionDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeDiffLedgerDeduction findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeDiffLedgerDeduction> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeDiffLedgerDeduction::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeDiffLedgerDeduction::getId, ids)
                .set(AuditFeeDiffLedgerDeduction::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeDiffLedgerDeduction::getId, ids)
                .set(AuditFeeDiffLedgerDeduction::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    /**
     * 查询已经存在的台帐扣减明细信息
     * @param feeDiffDisposeCode
     * @param detailPlanItemCodes
     * @return {@link List}<{@link AuditFeeDiffLedgerDeduction}>
     */
    public List<AuditFeeDiffLedgerDeduction> findByFeeDiffDisposeCodeAndDetailPlanItemCodes(String feeDiffDisposeCode, List<String> detailPlanItemCodes) {
        return this.lambdaQuery()
            .eq(AuditFeeDiffLedgerDeduction::getFeeDiffLedgerDisposeCode, feeDiffDisposeCode)
            .in(AuditFeeDiffLedgerDeduction::getBusinessCode, detailPlanItemCodes)
            .eq(AuditFeeDiffLedgerDeduction::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeDiffLedgerDeduction::getTenantCode, TenantUtils.getTenantCode())
            .list();
    }

    /**
     * 删除历史扣减明细
     * @param feeDiffDisposeCode
     */
    public void deleteByFeeDiffDisposeCode(String feeDiffDisposeCode) {
        this.lambdaUpdate()
            .eq(AuditFeeDiffLedgerDeduction::getFeeDiffLedgerDisposeCode, feeDiffDisposeCode)
            .set(AuditFeeDiffLedgerDeduction::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
            .update();
    }
}
