package com.biz.crm.tpm.business.audit.fee.local.repository.ledger;

import com.alibaba.nacos.client.utils.TenantUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedgerPlan;
import com.biz.crm.tpm.business.audit.fee.local.mapper.ledger.AuditFeeDiffLedgerPlanMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

/**
 * 核销差异费用台账计划明细(repository)
 *
 * @author liuyifan
 * @date 2022-12-22 14:55:41
 */
@Component
public class AuditFeeDiffLedgerPlanRepository extends ServiceImpl<AuditFeeDiffLedgerPlanMapper, AuditFeeDiffLedgerPlan> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeDiffLedgerPlanVo> findByConditions(Page<AuditFeeDiffLedgerPlanVo> page, AuditFeeDiffLedgerPlanDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeDiffLedgerPlan findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeDiffLedgerPlan> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeDiffLedgerPlan::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeDiffLedgerPlan::getId, ids)
                .set(AuditFeeDiffLedgerPlan::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeDiffLedgerPlan::getId, ids)
                .set(AuditFeeDiffLedgerPlan::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    public List<AuditFeeDiffLedgerPlan> findDetailByLedgerId(String feeDiffLedgerId) {
        return this.lambdaQuery().eq(AuditFeeDiffLedgerPlan::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeDiffLedgerPlan::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeDiffLedgerPlan::getFeeDiffLedgerId,feeDiffLedgerId)
                .list();
    }

    public void deleteByFeeDiffLedgerCode(String feeDiffLedgerId) {
        this.lambdaUpdate()
            .eq(AuditFeeDiffLedgerPlan::getFeeDiffLedgerId,feeDiffLedgerId)
            .set(AuditFeeDiffLedgerPlan::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
            .update();
    }

    /**
     * 查询明细
     * @param dto
     * @return {@link List}<{@link AuditFeeDiffLedgerPlan}>
     */
    public List<AuditFeeDiffLedgerPlan> findByFeeDiffLedgerCode(AuditFeeDiffLedgerPlanDto dto) {
        return this.lambdaQuery().eq(AuditFeeDiffLedgerPlan::getTenantCode, TenantUtils.getTenantCode())
            .eq(AuditFeeDiffLedgerPlan::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeDiffLedgerPlan::getFeeDiffLedgerCode, dto.getFeeDiffLedgerCode())
            .orderByAsc(AuditFeeDiffLedgerPlan::getSerialNumber)
            .list();
    }
}
