package com.biz.crm.tpm.business.audit.fee.local.repository.ledger;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import java.util.List;
import java.util.Optional;

import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedger;
import com.biz.crm.tpm.business.audit.fee.local.mapper.ledger.AuditFeeDiffLedgerMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 核销差异费用台账(repository)
 *
 * @author makejava
 * @date 2022-12-19 11:02:13
 */
@Component
public class AuditFeeDiffLedgerRepository extends ServiceImpl<AuditFeeDiffLedgerMapper, AuditFeeDiffLedger> {

    /**
     * 分页
     *
     * @param pageable
     * @param dto
     * @return
     */
    public Page<AuditFeeDiffLedgerVo> findByConditions(Pageable pageable, AuditFeeDiffLedgerDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffLedgerDto());
        Page<AuditFeeDiffLedgerVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (StringUtils.isEmpty(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeDiffLedger findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeDiffLedger> findByIds(List<String> ids) {
        return this.lambdaQuery()
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeDiffLedger::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditFeeDiffLedger::getId, ids)
                .set(AuditFeeDiffLedger::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditFeeDiffLedger::getId, ids)
                .set(AuditFeeDiffLedger::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    public List<AuditFeeDiffLedger> findDetailByCodes(List<String> ledgerCodes) {
        return this.lambdaQuery().eq(AuditFeeDiffLedger::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeDiffLedger::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditFeeDiffLedger::getFeeDiffLedgerCode, ledgerCodes)
                .list()
                ;
    }


    /**
     * 根据编码获取差异费用台帐
     *
     * @param k 差异费用台帐编码
     * @return {@link AuditFeeDiffLedger}
     */
    public AuditFeeDiffLedger findDetailByCode(String k) {
        return this.lambdaQuery()
                .eq(AuditFeeDiffLedger::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeDiffLedger::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeDiffLedger::getFeeDiffLedgerCode, k)

                .one();
    }

    /**
     * 选择台帐列表
     * @param page
     * @param dto
     * @return {@link Page}<{@link AuditFeeDiffLedgerVo}>
     */
    public Page<AuditFeeDiffLedgerVo> selectByConditions(Page<AuditFeeDiffLedgerVo> page, AuditFeeDiffLedgerDto dto) {
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.baseMapper.selectByConditions(page, dto);
    }
}
