package com.biz.crm.tpm.business.audit.fee.local.repository.prediction;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePrediction;
import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePredictionFormula;
import com.biz.crm.tpm.business.audit.fee.local.mapper.prediction.AuditFeePredictionFormulaMapper;
import com.biz.crm.tpm.business.audit.fee.local.mapper.prediction.AuditFeePredictionMapper;
import liquibase.pro.packaged.C;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 扣费预测计算公式
 *
 * @author zy
 * @date 2022-09-23
 */
@Component
public class AuditFeePredictionFormulaRepository extends ServiceImpl<AuditFeePredictionFormulaMapper, AuditFeePredictionFormula> {

    public void removeByDetailItemCodes(List<String> needUpdateFormula) {
        if (CollectionUtils.isEmpty(needUpdateFormula)) {
            return;
        }
        this.lambdaUpdate()
                .in(AuditFeePredictionFormula::getDetailPlanItemCode,needUpdateFormula)
                .remove();
    }
}
